/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;

public class OSQLMethodMultiValue
extends OAbstractSQLMethod {
    public static final String NAME = "multivalue";

    public OSQLMethodMultiValue() {
        super(NAME, 1, -1);
    }

    @Override
    public String getSyntax() {
        return "multivalue(<index>)";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis == null || iParams[0] == null) {
            return null;
        }
        if (iParams.length == 1 && !OMultiValue.isMultiValue((Object)iParams[0])) {
            return ODocumentHelper.getFieldValue(iThis, iParams[0].toString(), iContext);
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < iParams.length; ++i) {
            if (OMultiValue.isMultiValue((Object)iParams[i])) {
                for (Object o : OMultiValue.getMultiValueIterable((Object)iParams[i])) {
                    list.add(ODocumentHelper.getFieldValue(iThis, o.toString(), iContext));
                }
                continue;
            }
            list.add(ODocumentHelper.getFieldValue(iThis, iParams[i].toString(), iContext));
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }
}

