/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OQueryOperatorIn
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorIn() {
        super("IN", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!(iLeft instanceof Collection)) break block9;
                        Collection sourceCollection = (Collection)iLeft;
                        if (iRight instanceof Collection) {
                            Collection collectionToMatch = (Collection)iRight;
                            boolean found = false;
                            block0: for (Object o1 : sourceCollection) {
                                for (Object o2 : collectionToMatch) {
                                    if (!OQueryOperatorEquals.equals(o1, o2)) continue;
                                    found = true;
                                    continue block0;
                                }
                            }
                            return found;
                        }
                        if (sourceCollection instanceof Set) {
                            return sourceCollection.contains(iRight);
                        }
                        for (Object o : sourceCollection) {
                            if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                            return true;
                        }
                        break block10;
                    }
                    if (!(iRight instanceof Collection)) break block11;
                    Collection sourceCollection = (Collection)iRight;
                    if (sourceCollection instanceof Set) {
                        return sourceCollection.contains(iLeft);
                    }
                    for (Object o : sourceCollection) {
                        if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                        return true;
                    }
                    break block10;
                }
                if (!iLeft.getClass().isArray()) break block12;
                for (Object o : (Object[])iLeft) {
                    if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                    return true;
                }
                break block10;
            }
            if (!iRight.getClass().isArray()) break block10;
            for (Object o : (Object[])iRight) {
                if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                return true;
            }
        }
        return iLeft.equals(iRight);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        ArrayList<Object> inKeys;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            List inParams;
            Object inKeyValue = keyParams.get(0);
            if (inKeyValue instanceof List) {
                inParams = (List)inKeyValue;
            } else if (inKeyValue instanceof OSQLFilterItem) {
                inParams = (List)((OSQLFilterItem)inKeyValue).getValue(null, null, iContext);
            } else {
                throw new IllegalArgumentException("Key '" + inKeyValue + "' is not valid");
            }
            inKeys = new ArrayList<Object>();
            boolean containsNotCompatibleKey = false;
            for (Object keyValue : inParams) {
                Object key = indexDefinition.createValue(OSQLHelper.getValue(keyValue));
                if (key == null) {
                    containsNotCompatibleKey = true;
                    break;
                }
                inKeys.add(key);
            }
            if (containsNotCompatibleKey) {
                return null;
            }
        } else {
            return null;
        }
        OIndexCursor cursor = index.iterateEntries(inKeys, ascSortOrder);
        this.updateProfiler(iContext, internalIndex, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof OSQLFilterItem) {
                iLeft = ((OSQLFilterItem)iLeft).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable((Object)iLeft);
            ridSize = OMultiValue.getSize((Object)iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof OSQLFilterItem) {
                iRight = ((OSQLFilterItem)iRight).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable((Object)iRight);
            ridSize = OMultiValue.getSize((Object)iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.min(rids);
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof OSQLFilterItem) {
                iLeft = ((OSQLFilterItem)iLeft).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable((Object)iLeft);
            ridSize = OMultiValue.getSize((Object)iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof OSQLFilterItem) {
                iRight = ((OSQLFilterItem)iRight).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable((Object)iRight);
            ridSize = OMultiValue.getSize((Object)iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.max(rids);
    }

    protected List<ORID> addRangeResults(Iterable<?> ridCollection, int ridSize) {
        if (ridCollection == null) {
            return null;
        }
        ArrayList<ORID> rids = null;
        for (Object rid : ridCollection) {
            ORID r;
            if (rid instanceof OSQLFilterItemParameter) {
                rid = ((OSQLFilterItemParameter)rid).getValue(null, null, null);
            }
            if (!(rid instanceof OIdentifiable) || !(r = ((OIdentifiable)rid).getIdentity()).isPersistent()) continue;
            if (rids == null) {
                rids = new ArrayList<ORID>(ridSize);
            }
            rids.add(r);
        }
        return rids;
    }
}

