/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryLinearHashingClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfigurationLocal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemoryArrayList;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemoryHashing;
import java.util.Arrays;

public class ODefaultClusterFactory
implements OClusterFactory {
    protected static final String[] TYPES = new String[]{"PHYSICAL", "MEMORY"};

    @Override
    public OCluster createCluster(String type) {
        if (type.equalsIgnoreCase("PHYSICAL")) {
            return new OClusterLocal();
        }
        if (type.equalsIgnoreCase("MEMORY")) {
            return new OClusterMemoryArrayList();
        }
        throw new OStorageException("Cluster type '" + type + "' is not supported. Supported types are: " + Arrays.toString(TYPES));
    }

    @Override
    public OCluster createCluster(OStorageClusterConfiguration config) {
        if (config instanceof OStoragePhysicalClusterConfigurationLocal) {
            return new OClusterLocal();
        }
        if (config instanceof OStorageMemoryClusterConfiguration) {
            return new OClusterMemoryArrayList();
        }
        if (config instanceof OStorageMemoryLinearHashingClusterConfiguration) {
            return new OClusterMemoryHashing();
        }
        throw new OStorageException("Cluster type '" + config + "' is not supported. Supported types are: " + Arrays.toString(TYPES));
    }

    @Override
    public String[] getSupported() {
        return TYPES;
    }

    @Override
    public boolean isSupported(String iClusterType) {
        for (String type : TYPES) {
            if (!type.equalsIgnoreCase(iClusterType)) continue;
            return true;
        }
        return false;
    }
}

