/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OPhysicalPosition
implements OSerializableStream,
Comparable<OPhysicalPosition>,
Externalizable {
    public OClusterPosition clusterPosition;
    public int dataSegmentId;
    public long dataSegmentPos;
    public byte recordType;
    public ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
    public int recordSize;
    public static int binarySize;
    private static boolean binarySizeKnown;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(OClusterPosition iClusterPosition) {
        this.clusterPosition = iClusterPosition;
    }

    public OPhysicalPosition(int iDataSegmentId, long iDataSegmentPosition, byte iRecordType) {
        this.dataSegmentId = iDataSegmentId;
        this.dataSegmentPos = iDataSegmentPosition;
        this.recordType = iRecordType;
    }

    public OPhysicalPosition(OClusterPosition iClusterPosition, ORecordVersion iVersion) {
        this.clusterPosition = iClusterPosition;
        this.recordVersion.copyFrom(iVersion);
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.clusterPosition = this.clusterPosition;
        iDest.dataSegmentId = this.dataSegmentId;
        iDest.dataSegmentPos = this.dataSegmentPos;
        iDest.recordType = this.recordType;
        iDest.recordVersion = this.recordVersion;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "rid(?:" + this.clusterPosition + ") data(" + this.dataSegmentId + ":" + this.dataSegmentPos + ") record(type:" + this.recordType + " size:" + this.recordSize + " v:" + this.recordVersion + ")";
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.clusterPosition = OClusterPositionFactory.INSTANCE.fromStream(iStream);
        this.dataSegmentId = OBinaryProtocol.bytes2int(iStream, pos += OClusterPositionFactory.INSTANCE.getSerializedSize());
        this.dataSegmentPos = OBinaryProtocol.bytes2long(iStream, pos += 4);
        this.recordType = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.recordVersion.getSerializer().readFrom(iStream, pos += 4, this.recordVersion);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[OPhysicalPosition.binarySize()];
        int pos = 0;
        byte[] clusterContent = this.clusterPosition.toStream();
        System.arraycopy(clusterContent, 0, buffer, 0, clusterContent.length);
        OBinaryProtocol.int2bytes(this.dataSegmentId, buffer, pos += clusterContent.length);
        OBinaryProtocol.long2bytes(this.dataSegmentPos, buffer, pos += 4);
        buffer[pos += 8] = this.recordType;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        this.recordVersion.getSerializer().writeTo(buffer, pos += 4, this.recordVersion);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OPhysicalPosition)) {
            return false;
        }
        OPhysicalPosition other = (OPhysicalPosition)obj;
        return this.clusterPosition.equals(other.clusterPosition) && this.recordType == other.recordType && this.recordVersion.equals(other.recordVersion) && this.recordSize == other.recordSize;
    }

    public int hashCode() {
        int result = this.clusterPosition != null ? this.clusterPosition.hashCode() : 0;
        result = 31 * result + this.dataSegmentId;
        result = 31 * result + (int)(this.dataSegmentPos ^ this.dataSegmentPos >>> 32);
        result = 31 * result + this.recordType;
        result = 31 * result + (this.recordVersion != null ? this.recordVersion.hashCode() : 0);
        result = 31 * result + this.recordSize;
        return result;
    }

    @Override
    public int compareTo(OPhysicalPosition iOther) {
        return (int)(this.dataSegmentPos - iOther.dataSegmentPos);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] clusterContent = this.clusterPosition.toStream();
        out.write(clusterContent);
        out.writeInt(this.dataSegmentId);
        out.writeLong(this.dataSegmentPos);
        out.writeByte(this.recordType);
        out.writeInt(this.recordSize);
        this.recordVersion.getSerializer().writeTo(out, this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterPosition = OClusterPositionFactory.INSTANCE.fromStream(in);
        this.dataSegmentId = in.readInt();
        this.dataSegmentPos = in.readLong();
        this.recordType = in.readByte();
        this.recordSize = in.readInt();
        this.recordVersion.getSerializer().readFrom(in, this.recordVersion);
    }

    public static int binarySize() {
        if (binarySizeKnown) {
            return binarySize;
        }
        binarySizeKnown = true;
        binarySize = OClusterPositionFactory.INSTANCE.getSerializedSize() + 4 + 8 + 1 + OVersionFactory.instance().getVersionSize() + 4;
        return binarySize;
    }

    static {
        binarySizeKnown = false;
    }
}

