/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.factory.OConfigurableStatefulFactory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.io.IOException;

public class OFileFactory
extends OConfigurableStatefulFactory<String, OFile> {
    protected static final OFileFactory instance = new OFileFactory();

    public OFileFactory() {
        this.register("mmap", OFileMMap.class);
        this.register("classic", OFileClassic.class);
    }

    public static OFileFactory instance() {
        return instance;
    }

    public OFile create(String iType, String iFileName, String iOpenMode) throws IOException {
        Class fileClass = (Class)this.registry.get(iType);
        try {
            OFile f = (OFile)this.newInstance(iType);
            f.init(iFileName, iOpenMode);
            return f;
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot create file of type '" + iType + "'", e);
        }
    }
}

