/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OMMapBufferEntry
implements Comparable<OMMapBufferEntry> {
    private static final OProfilerMBean PROFILER = Orient.instance().getProfiler();
    private static final int FORCE_DELAY = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
    private static final int FORCE_RETRY = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
    static Method cleanerMethod;
    Lock lock = new ReentrantLock();
    volatile OFileMMap file;
    volatile MappedByteBuffer buffer;
    final long beginOffset;
    final int size;
    volatile boolean dirty;
    private volatile long lastUsed;

    public OMMapBufferEntry(OFileMMap iFile, MappedByteBuffer buffer, long beginOffset, int size) {
        this.file = iFile;
        this.buffer = buffer;
        this.beginOffset = beginOffset;
        this.size = size;
        this.dirty = false;
        this.updateLastUsedTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flush() {
        this.lock.lock();
        try {
            if (!this.dirty) {
                boolean bl = true;
                return bl;
            }
            long timer = PROFILER.startChrono();
            for (int i = 0; i < FORCE_RETRY; ++i) {
                try {
                    this.buffer.force();
                    this.dirty = false;
                    break;
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Cannot write memory buffer to disk. Retrying (" + (i + 1) + "/" + FORCE_RETRY + ")...", new Object[0]);
                    OMemoryWatchDog.freeMemoryForResourceCleanup(FORCE_DELAY);
                    continue;
                }
            }
            if (this.dirty) {
                OLogManager.instance().debug((Object)this, "Cannot commit memory buffer to disk after %d retries", new Object[]{FORCE_RETRY});
            } else {
                PROFILER.updateCounter(PROFILER.getProcessMetric("file.mmap.pagesCommitted"), "Memory mapped pages committed to disk", 1L);
            }
            PROFILER.stopChrono(PROFILER.getProcessMetric("file.mmap.commitPages"), "Commit memory mapped pages to disk", timer);
            boolean bl = !this.dirty;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OMMapBufferEntry [file=").append(this.file).append(", beginOffset=").append(this.beginOffset).append(", size=").append(this.size).append("]");
        return builder.toString();
    }

    void close() {
        this.lock.lock();
        try {
            if (this.buffer != null) {
                if (this.dirty) {
                    this.buffer.force();
                }
                if (cleanerMethod != null) {
                    try {
                        Object cleaner = cleanerMethod.invoke((Object)this.buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on calling Sun's MMap buffer clean", (Throwable)e, new Object[0]);
                    }
                }
                this.buffer = null;
            }
            this.lastUsed = 0L;
            this.file = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int compareTo(OMMapBufferEntry iOther) {
        return (int)(this.beginOffset - iOther.beginOffset);
    }

    boolean isValid() {
        return this.buffer != null;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty() {
        this.dirty = true;
    }

    void acquireLock() {
        this.lock.lock();
    }

    void releaseLock() {
        this.lock.unlock();
    }

    public void updateLastUsedTime() {
        this.lastUsed = System.currentTimeMillis();
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    static {
        try {
            Class<?> sunClass = Class.forName("sun.nio.ch.DirectBuffer");
            cleanerMethod = sunClass.getMethod("cleaner", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

