/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.core.storage.impl.local.OSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OMultiFileSegment
extends OSegment {
    protected OStorageSegmentConfiguration config;
    protected OFile[] files = new OFile[0];
    private final String fileExtension;
    private final String type;
    private final long maxSize;
    private final String defrag;
    private int fileStartSize;
    private final int fileMaxSize;
    private final int fileIncrementSize;
    private boolean wasSoftlyClosedAtPreviousTime = true;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMultiFileSegment(OStorageLocalAbstract storage, OStorageSegmentConfiguration config, String fileExtension, int roundMaxSize) throws IOException {
        super(storage, config.name);
        this.readWriteLock.writeLock().lock();
        try {
            this.config = config;
            this.fileExtension = fileExtension;
            this.type = config.fileType;
            this.defrag = config.defrag;
            this.maxSize = OFileUtils.getSizeAsNumber((Object)config.maxSize);
            this.fileStartSize = (int)OFileUtils.getSizeAsNumber((Object)config.fileStartSize);
            int tmpFileMaxSize = (int)OFileUtils.getSizeAsNumber((Object)config.fileMaxSize);
            this.fileIncrementSize = (int)OFileUtils.getSizeAsNumber((Object)config.fileIncrementSize);
            this.fileMaxSize = roundMaxSize > 0 ? tmpFileMaxSize / roundMaxSize * roundMaxSize : tmpFileMaxSize;
            if (config.infoFiles.length == 0) {
                this.files = new OFile[1];
                this.files[0] = OFileFactory.instance().create(this.type, storage.getVariableParser().resolveVariables(this.config.getLocation() + "/" + this.name + "." + 0 + this.fileExtension), storage.getMode());
                int perFileMaxSize = this.fileMaxSize;
                this.files[0].setMaxSize(perFileMaxSize);
                this.files[0].setIncrementSize(this.fileIncrementSize);
            } else {
                this.files = new OFile[config.infoFiles.length];
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i] = OFileFactory.instance().create(this.type, storage.getVariableParser().resolveVariables(config.infoFiles[i].path), storage.getMode());
                    int perFileMaxSize = this.fileMaxSize;
                    this.files[i].setMaxSize(perFileMaxSize);
                    this.files[i].setIncrementSize(this.fileIncrementSize);
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            for (OFile file : this.files) {
                if (file.open()) continue;
                OLogManager.instance().warn((Object)this, "segment file '%s' was not closed correctly last time", new Object[]{OFileUtils.getPath((String)file.getName())});
                this.wasSoftlyClosedAtPreviousTime = false;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void create(int iStartSize) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            this.files = new OFile[1];
            this.fileStartSize = iStartSize;
            this.createNewFile();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            for (OFile file : this.files) {
                if (file == null) continue;
                file.close();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            for (OFile file : this.files) {
                if (file == null) continue;
                file.delete();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public boolean exists() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.files[0].exists();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void truncate() throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            this.files[0].shrink(0L);
            if (this.files.length > 1) {
                for (int i = 1; i < this.files.length; ++i) {
                    if (this.files[i] == null) continue;
                    this.files[i].delete();
                }
                OFile f = this.files[0];
                this.files = new OFile[1];
                this.files[0] = f;
                OStorageFileConfiguration fileConfig = this.config.infoFiles[0];
                this.config.infoFiles = new OStorageFileConfiguration[1];
                this.config.infoFiles[0] = fileConfig;
                this.config.root.update();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            for (OFile file : this.files) {
                if (file == null || !file.isOpen()) continue;
                file.synch();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            for (OFile file : this.files) {
                if (file == null || !file.isOpen()) continue;
                file.setSoftlyClosed(softlyClosed);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public OStorageSegmentConfiguration getConfig() {
        this.readWriteLock.readLock().lock();
        try {
            OStorageSegmentConfiguration oStorageSegmentConfiguration = this.config;
            return oStorageSegmentConfiguration;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilledUpTo() {
        this.readWriteLock.readLock().lock();
        try {
            long filled = 0L;
            for (OFile file : this.files) {
                filled += file.getFilledUpTo();
            }
            long l = filled;
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.readWriteLock.readLock().lock();
        try {
            long size = 0L;
            for (OFile file : this.files) {
                size += file.getFileSize();
            }
            long l = size;
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] allocateSpace(int iRecordSize) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            OFile file;
            int i;
            for (i = 0; i < this.files.length; ++i) {
                file = this.files[i];
                if (file.getFreeSpace() < (long)iRecordSize) continue;
                long[] lArray = new long[]{i, file.allocateSpace(iRecordSize)};
                return lArray;
            }
            for (i = 0; i < this.files.length; ++i) {
                file = this.files[i];
                if (!file.canOversize(iRecordSize)) continue;
                long[] lArray = new long[]{i, file.allocateSpace(iRecordSize)};
                return lArray;
            }
            if (this.maxSize > 0L && this.getSize() >= this.maxSize) {
                throw new OStorageException("Unable to allocate the requested space of " + iRecordSize + " bytes because the segment is full: max-Size=" + this.maxSize + ", currentSize=" + this.getFilledUpTo());
            }
            OFile[] newFiles = new OFile[this.files.length + 1];
            System.arraycopy(this.files, 0, newFiles, 0, this.files.length);
            this.files = newFiles;
            file = this.createNewFile();
            file.allocateSpace(iRecordSize);
            this.config.root.update();
            long[] lArray = new long[]{this.files.length - 1, 0L};
            return lArray;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAbsolutePosition(long[] iFilePosition) {
        this.readWriteLock.readLock().lock();
        try {
            long position = 0L;
            int i = 0;
            while ((long)i < iFilePosition[0]) {
                position += (long)this.fileMaxSize;
                ++i;
            }
            long l = position + iFilePosition[1];
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getRelativePosition(long iPosition) {
        this.readWriteLock.readLock().lock();
        try {
            if (iPosition < (long)this.fileMaxSize) {
                long[] lArray = new long[]{0L, iPosition};
                return lArray;
            }
            int fileNum = (int)(iPosition / (long)this.fileMaxSize);
            if (fileNum >= this.files.length && fileNum < 0) {
                throw new ODatabaseException("Record position #" + iPosition + " was bound to file #" + fileNum + " that is out of limit (files range 0-" + (this.files.length - 1) + ")");
            }
            int fileRec = (int)(iPosition % (long)this.fileMaxSize);
            if (fileNum >= this.files.length) {
                throw new ODatabaseException("Record position #" + iPosition + " was bound to file #" + fileNum + " but configured files are only " + this.files.length);
            }
            if ((long)fileRec >= this.files[fileNum].getFilledUpTo() && fileRec < 0) {
                throw new ODatabaseException("Record position #" + iPosition + " was bound to file #" + fileNum + " but the position #" + fileRec + " is out of file size " + this.files[fileNum].getFilledUpTo());
            }
            long[] lArray = new long[]{fileNum, fileRec};
            return lArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private OFile createNewFile() throws IOException {
        int num = this.files.length - 1;
        OFile file = OFileFactory.instance().create(this.type, this.config.getLocation() + "/" + this.name + "." + num + this.fileExtension, this.storage.getMode());
        file.setMaxSize(this.fileMaxSize);
        file.create(this.fileStartSize);
        this.files[num] = file;
        this.addInfoFileConfigEntry(file);
        return file;
    }

    private void addInfoFileConfigEntry(OFile file) throws IOException {
        OStorageFileConfiguration[] newConfigFiles = new OStorageFileConfiguration[this.config.infoFiles.length + 1];
        for (int i = 0; i < this.config.infoFiles.length; ++i) {
            newConfigFiles[i] = this.config.infoFiles[i];
        }
        this.config.infoFiles = newConfigFiles;
        String fileNameToStore = this.storage.getVariableParser().convertPathToRelative(OFileUtils.getPath((String)file.getPath()));
        OStorageSegmentConfiguration template = this.config.root.fileTemplate;
        this.config.infoFiles[this.config.infoFiles.length - 1] = new OStorageFileConfiguration(this.config, fileNameToStore, template.fileType, template.fileMaxSize, template.fileIncrementSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateSpaceContinuously(int iSize) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            OFile file;
            int remainingSize = iSize;
            long offset = -1L;
            int fileNumber = -1;
            if (this.files.length > 0) {
                long oversize;
                file = this.files[this.files.length - 1];
                if (file.getFreeSpace() > 0L) {
                    fileNumber = this.files.length - 1;
                    if ((long)remainingSize > file.getFreeSpace()) {
                        remainingSize = (int)((long)remainingSize - file.getFreeSpace());
                        offset = file.allocateSpace(file.getFreeSpace());
                    } else {
                        long l = (long)(this.files.length - 1) * (long)this.fileMaxSize + file.allocateSpace(remainingSize);
                        return l;
                    }
                }
                if ((oversize = (long)this.fileMaxSize - file.getFileSize()) > 0L && remainingSize > 0) {
                    fileNumber = this.files.length - 1;
                    if ((long)remainingSize > oversize) {
                        remainingSize = (int)((long)remainingSize - oversize);
                        long newOffset = file.allocateSpace(oversize);
                        if (offset == -1L) {
                            offset = newOffset;
                        }
                    } else {
                        long newOffset = file.allocateSpace(remainingSize);
                        if (offset == -1L) {
                            offset = newOffset;
                        }
                        if (fileNumber == -1) {
                            fileNumber = this.files.length - 1;
                        }
                        long l = (long)fileNumber * (long)this.fileMaxSize + offset;
                        return l;
                    }
                }
            }
            if (remainingSize > 0) {
                if (this.maxSize > 0L && this.getSize() >= this.maxSize) {
                    throw new OStorageException("Unable to allocate the requested space of " + iSize + " bytes because the segment is full: max-Size=" + this.maxSize + ", currentSize=" + this.getFilledUpTo());
                }
                OFile[] newFiles = new OFile[this.files.length + 1];
                for (int i = 0; i < this.files.length; ++i) {
                    newFiles[i] = this.files[i];
                }
                this.files = newFiles;
                file = this.createNewFile();
                file.allocateSpace(iSize);
                this.config.root.update();
                if (fileNumber == -1) {
                    fileNumber = this.files.length - 1;
                }
                if (offset == -1L) {
                    offset = 0L;
                }
            }
            long l = (long)fileNumber * (long)this.fileMaxSize + offset;
            return l;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContinuously(long iPosition, byte[] iData) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            int remainingSize = iData.length;
            long offset = pos[1];
            int i = (int)pos[0];
            while (remainingSize > 0) {
                OFile file = this.files[i];
                if ((long)remainingSize > file.getFilledUpTo() - offset) {
                    if (file.getFilledUpTo() < offset) {
                        throw new ODatabaseException("range check! " + file.getFilledUpTo() + " " + offset);
                    }
                    file.write(offset, iData, (int)(file.getFilledUpTo() - offset), iData.length - remainingSize);
                    remainingSize = (int)((long)remainingSize - (file.getFilledUpTo() - offset));
                } else {
                    file.write(offset, iData, remainingSize, iData.length - remainingSize);
                    remainingSize = 0;
                }
                offset = 0L;
                ++i;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContinuously(long iPosition, byte[] iData, int arrayOffset, int length) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            int remainingSize = length;
            long offset = pos[1];
            int i = (int)pos[0];
            while (remainingSize > 0) {
                OFile file = this.files[i];
                if ((long)remainingSize > file.getFilledUpTo() - offset) {
                    if (file.getFilledUpTo() < offset) {
                        throw new ODatabaseException("range check! " + file.getFilledUpTo() + " " + offset);
                    }
                    file.write(offset, iData, (int)(file.getFilledUpTo() - offset), arrayOffset + iData.length - remainingSize);
                    remainingSize = (int)((long)remainingSize - (file.getFilledUpTo() - offset));
                } else {
                    file.write(offset, iData, remainingSize, arrayOffset + iData.length - remainingSize);
                    remainingSize = 0;
                }
                offset = 0L;
                ++i;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readContinuously(long iPosition, byte[] iBuffer, int iSize) throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            int remainingSize = iSize;
            long offset = pos[1];
            assert (offset < Integer.MAX_VALUE);
            assert (offset > -1L);
            int i = (int)pos[0];
            while (remainingSize > 0) {
                OFile file = this.files[i];
                if ((long)remainingSize > file.getFilledUpTo() - offset) {
                    if (file.getFilledUpTo() < offset) {
                        throw new ODatabaseException("range check! " + file.getFilledUpTo() + " " + offset);
                    }
                    int toRead = (int)(file.getFilledUpTo() - offset);
                    file.read(offset, iBuffer, toRead, iSize - remainingSize);
                    remainingSize -= toRead;
                } else {
                    file.read(offset, iBuffer, remainingSize, iSize - remainingSize);
                    remainingSize = 0;
                }
                offset = 0L;
                ++i;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String iOldName, String iNewName) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            for (OFile file : this.files) {
                String osFileName = file.getName();
                if (!osFileName.startsWith(this.name)) continue;
                File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFileName.substring(osFileName.lastIndexOf(this.name) + this.name.length()));
                for (OStorageFileConfiguration conf : this.config.infoFiles) {
                    if (conf.parent.name.equals(this.name)) {
                        conf.parent.name = iNewName;
                    }
                    if (!conf.path.endsWith(osFileName)) continue;
                    conf.path = new String(conf.path.replace(osFileName, newFile.getName()));
                }
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                    renamed = file.renameTo(newFile);
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public boolean wasSoftlyClosedAtPreviousTime() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.wasSoftlyClosedAtPreviousTime;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

