/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPageChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class OStorageLocalAbstract
extends OStorageEmbedded
implements OFreezableStorage {
    protected volatile OWriteAheadLog writeAheadLog;
    protected volatile ODiskCache diskCache;
    protected volatile OAtomicOperationsManager atomicOperationsManager;
    protected final ThreadLocal<OStorageTransaction> transaction = new ThreadLocal();

    public OStorageLocalAbstract(String name, String filePath, String mode) {
        super(name, filePath, mode);
    }

    public abstract OStorageVariableParser getVariableParser();

    public abstract String getMode();

    public abstract String getStoragePath();

    protected abstract OPhysicalPosition updateRecord(OCluster var1, ORecordId var2, byte[] var3, ORecordVersion var4, byte var5);

    protected abstract OPhysicalPosition createRecord(ODataLocal var1, OCluster var2, byte[] var3, byte var4, ORecordId var5, ORecordVersion var6);

    public abstract ODiskCache getDiskCache();

    public abstract boolean check(boolean var1, OCommandOutputListener var2);

    public OStorageTransaction getStorageTransaction() {
        return this.transaction.get();
    }

    public OAtomicOperationsManager getAtomicOperationsManager() {
        return this.atomicOperationsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iOutput, int compressionLevel, int bufferSize) throws IOException {
        this.freeze(false);
        try {
            if (callable != null) {
                try {
                    callable.call();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on callback invocation during backup", (Throwable)e, new Object[0]);
                }
            }
            OutputStream bo = bufferSize > 0 ? new BufferedOutputStream(out, bufferSize) : out;
            try {
                OZIPCompressionUtil.compressDirectory(new File(this.getStoragePath()).getAbsolutePath(), bo, new String[]{".wal"}, iOutput, compressionLevel);
            }
            finally {
                if (bufferSize > 0) {
                    bo.flush();
                    bo.close();
                }
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        if (!this.isClosed()) {
            this.close();
        }
        OZIPCompressionUtil.uncompressDirectory(in, this.getStoragePath(), iListener);
    }

    protected void endStorageTx() throws IOException {
        this.atomicOperationsManager.endAtomicOperation(false);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    protected void startStorageTx(OTransaction clientTx) throws IOException {
        if (this.writeAheadLog == null) {
            return;
        }
        OStorageTransaction storageTx = this.transaction.get();
        if (storageTx != null && storageTx.getClientTx().getId() != clientTx.getId()) {
            this.rollback(clientTx);
        }
        this.atomicOperationsManager.startAtomicOperation();
        this.transaction.set(new OStorageTransaction(clientTx));
    }

    protected void rollbackStorageTx() throws IOException {
        if (this.writeAheadLog == null || this.transaction.get() == null) {
            return;
        }
        OAtomicOperation operation = this.atomicOperationsManager.endAtomicOperation(true);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
        List<OLogSequenceNumber> operationUnit = this.readOperationUnit(operation.getStartLSN(), operation.getOperationUnitId());
        this.undoOperation(operationUnit);
    }

    private List<OLogSequenceNumber> readOperationUnit(OLogSequenceNumber startLSN, OOperationUnitId unitId) throws IOException {
        OLogSequenceNumber beginSequence = this.writeAheadLog.begin();
        if (startLSN == null) {
            startLSN = beginSequence;
        }
        if (startLSN.compareTo(beginSequence) < 0) {
            startLSN = beginSequence;
        }
        ArrayList<OLogSequenceNumber> operationUnit = new ArrayList<OLogSequenceNumber>();
        OLogSequenceNumber lsn = startLSN;
        while (lsn != null) {
            OWALRecord record = this.writeAheadLog.read(lsn);
            if (!(record instanceof OOperationUnitRecord)) {
                lsn = this.writeAheadLog.next(lsn);
                continue;
            }
            OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)record;
            if (operationUnitRecord.getOperationUnitId().equals(unitId)) {
                operationUnit.add(lsn);
                if (record instanceof OAtomicUnitEndRecord) break;
            }
            lsn = this.writeAheadLog.next(lsn);
        }
        return operationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undoOperation(List<OLogSequenceNumber> operationUnit) throws IOException {
        for (int i = operationUnit.size() - 1; i >= 0; --i) {
            OWALRecord record = this.writeAheadLog.read(operationUnit.get(i));
            if (this.checkFirstAtomicUnitRecord(i, record)) {
                assert (((OAtomicUnitStartRecord)record).isRollbackSupported());
                continue;
            }
            if (this.checkLastAtomicUnitRecord(i, record, operationUnit.size())) {
                assert (((OAtomicUnitEndRecord)record).isRollback());
                continue;
            }
            if (record instanceof OUpdatePageRecord) {
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)record;
                long fileId = updatePageRecord.getFileId();
                long pageIndex = updatePageRecord.getPageIndex();
                if (!this.diskCache.isOpen(fileId)) {
                    this.diskCache.openFile(fileId);
                }
                OCacheEntry cacheEntry = this.diskCache.load(fileId, pageIndex, true);
                OCachePointer cachePointer = cacheEntry.getCachePointer();
                cachePointer.acquireExclusiveLock();
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry, ODurablePage.TrackMode.NONE);
                    OPageChanges pageChanges = updatePageRecord.getChanges();
                    durablePage.revertChanges(pageChanges);
                    durablePage.setLsn(updatePageRecord.getLsn());
                    continue;
                }
                finally {
                    cachePointer.releaseExclusiveLock();
                    this.diskCache.release(cacheEntry);
                }
            }
            if (record instanceof OFileCreatedCreatedWALRecord) {
                OFileCreatedCreatedWALRecord fileCreatedCreatedRecord = (OFileCreatedCreatedWALRecord)record;
                this.diskCache.openFile(fileCreatedCreatedRecord.getFileName(), fileCreatedCreatedRecord.getFileId());
                this.diskCache.deleteFile(fileCreatedCreatedRecord.getFileId());
                continue;
            }
            OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{record.getClass()});
            assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
        }
    }

    protected boolean checkFirstAtomicUnitRecord(int index, OWALRecord record) {
        boolean isAtomicUnitStartRecord = record instanceof OAtomicUnitStartRecord;
        if (isAtomicUnitStartRecord && index != 0) {
            OLogManager.instance().error((Object)this, "Record %s should be the first record in WAL record list.", new Object[]{OAtomicUnitStartRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitStartRecord.class.getName() + " should be the first record in WAL record list.";
        }
        if (index == 0 && !isAtomicUnitStartRecord) {
            OLogManager.instance().error((Object)this, "Record %s should be the first record in WAL record list.", new Object[]{OAtomicUnitStartRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitStartRecord.class.getName() + " should be the first record in WAL record list.";
        }
        return isAtomicUnitStartRecord;
    }

    protected boolean checkLastAtomicUnitRecord(int index, OWALRecord record, int size) {
        boolean isAtomicUnitEndRecord = record instanceof OAtomicUnitEndRecord;
        if (isAtomicUnitEndRecord && index != size - 1) {
            OLogManager.instance().error((Object)this, "Record %s should be the last record in WAL record list.", new Object[]{OAtomicUnitEndRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitEndRecord.class.getName() + " should be the last record in WAL record list.";
        }
        if (index == size - 1 && !isAtomicUnitEndRecord) {
            OLogManager.instance().error((Object)this, "Record %s should be the last record in WAL record list.", new Object[]{OAtomicUnitEndRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitEndRecord.class.getName() + " should be the last record in WAL record list.";
        }
        return isAtomicUnitEndRecord;
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }
}

