/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.eh;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterPositionSerializer;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;

public class OPhysicalPositionSerializer
implements OBinarySerializer<OPhysicalPosition> {
    public static final OPhysicalPositionSerializer INSTANCE = new OPhysicalPositionSerializer();
    public static final byte ID = 50;

    public int getObjectSize(OPhysicalPosition object, Object ... hints) {
        return this.getFixedLength();
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        return this.getFixedLength();
    }

    public void serialize(OPhysicalPosition object, byte[] stream, int startPosition, Object ... hints) {
        int position = startPosition;
        OClusterPositionSerializer.INSTANCE.serialize(object.clusterPosition, stream, position, new Object[0]);
        object.recordVersion.getSerializer().writeTo(stream, position += OClusterPositionSerializer.INSTANCE.getFixedLength(), object.recordVersion);
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(object.dataSegmentId), stream, position += OVersionFactory.instance().getVersionSize(), new Object[0]);
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(object.recordSize), stream, position += 4, new Object[0]);
        OLongSerializer.INSTANCE.serialize(Long.valueOf(object.dataSegmentPos), stream, position += 4, new Object[0]);
        OByteSerializer.INSTANCE.serialize(Byte.valueOf(object.recordType), stream, position += 8, new Object[0]);
    }

    public OPhysicalPosition deserialize(byte[] stream, int startPosition) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        int position = startPosition;
        physicalPosition.clusterPosition = OClusterPositionSerializer.INSTANCE.deserialize(stream, position);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.getSerializer().readFrom(stream, position += OClusterPositionSerializer.INSTANCE.getFixedLength(), version);
        physicalPosition.dataSegmentId = OIntegerSerializer.INSTANCE.deserialize(stream, position += OVersionFactory.instance().getVersionSize());
        physicalPosition.recordSize = OIntegerSerializer.INSTANCE.deserialize(stream, position += 4);
        physicalPosition.dataSegmentPos = OLongSerializer.INSTANCE.deserialize(stream, position += 4);
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserialize(stream, position += 8);
        return physicalPosition;
    }

    public byte getId() {
        return 50;
    }

    public boolean isFixedLength() {
        return true;
    }

    public int getFixedLength() {
        int clusterPositionSize = OClusterPositionSerializer.INSTANCE.getFixedLength();
        int versionSize = OVersionFactory.instance().getVersionSize();
        return clusterPositionSize + versionSize + 8 + 8 + 1;
    }

    public void serializeNative(OPhysicalPosition object, byte[] stream, int startPosition, Object ... hints) {
        int position = startPosition;
        OClusterPositionSerializer.INSTANCE.serializeNative(object.clusterPosition, stream, position, new Object[0]);
        object.recordVersion.getSerializer().fastWriteTo(stream, position += OClusterPositionSerializer.INSTANCE.getFixedLength(), object.recordVersion);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(object.dataSegmentId), stream, position += OVersionFactory.instance().getVersionSize(), new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(object.recordSize), stream, position += 4, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(object.dataSegmentPos), stream, position += 4, new Object[0]);
        OByteSerializer.INSTANCE.serializeNative(Byte.valueOf(object.recordType), stream, position += 8, new Object[0]);
    }

    public OPhysicalPosition deserializeNative(byte[] stream, int startPosition) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        int position = startPosition;
        physicalPosition.clusterPosition = OClusterPositionSerializer.INSTANCE.deserializeNative(stream, position);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.getSerializer().fastReadFrom(stream, position += OClusterPositionSerializer.INSTANCE.getFixedLength(), version);
        physicalPosition.dataSegmentId = OIntegerSerializer.INSTANCE.deserializeNative(stream, position += OVersionFactory.instance().getVersionSize());
        physicalPosition.recordSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, position += 4);
        physicalPosition.dataSegmentPos = OLongSerializer.INSTANCE.deserializeNative(stream, position += 4);
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeNative(stream, position += 8);
        return physicalPosition;
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getFixedLength();
    }

    public void serializeInDirectMemory(OPhysicalPosition object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        long currentOffset = offset;
        OClusterPositionSerializer.INSTANCE.serializeInDirectMemory(object.clusterPosition, pointer, currentOffset, new Object[0]);
        byte[] serializedVersion = new byte[OVersionFactory.instance().getVersionSize()];
        object.recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, object.recordVersion);
        pointer.set(currentOffset += (long)OClusterPositionSerializer.INSTANCE.getFixedLength(), serializedVersion, 0, serializedVersion.length);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(object.dataSegmentId), pointer, currentOffset += (long)OVersionFactory.instance().getVersionSize(), new Object[0]);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(object.recordSize), pointer, currentOffset += 4L, new Object[0]);
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(object.dataSegmentPos), pointer, currentOffset += 4L, new Object[0]);
        OByteSerializer.INSTANCE.serializeInDirectMemory(Byte.valueOf(object.recordType), pointer, currentOffset += 8L, new Object[0]);
    }

    public OPhysicalPosition deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        long currentPointer = offset;
        physicalPosition.clusterPosition = OClusterPositionSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        byte[] serializedVersion = pointer.get(currentPointer += (long)OClusterPositionSerializer.INSTANCE.getFixedLength(), OVersionFactory.instance().getVersionSize());
        version.getSerializer().fastReadFrom(serializedVersion, 0, version);
        physicalPosition.recordVersion = version;
        physicalPosition.dataSegmentId = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += (long)OVersionFactory.instance().getVersionSize());
        OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += 4L);
        physicalPosition.dataSegmentPos = OLongSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += 4L);
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += 8L);
        return physicalPosition;
    }

    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return this.getFixedLength();
    }

    public OPhysicalPosition preprocess(OPhysicalPosition value, Object ... hints) {
        return value;
    }
}

