/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import java.util.ArrayDeque;
import java.util.Deque;

public class ORecordSerializationContext {
    private static final ThreadLocal<Deque<ORecordSerializationContext>> SERIALIZATION_CONTEXT_STACK = new ThreadLocal<Deque<ORecordSerializationContext>>(){

        @Override
        protected Deque<ORecordSerializationContext> initialValue() {
            return new ArrayDeque<ORecordSerializationContext>();
        }
    };
    private final Deque<ORecordSerializationOperation> operations = new ArrayDeque<ORecordSerializationOperation>();

    public static int getDepth() {
        return SERIALIZATION_CONTEXT_STACK.get().size();
    }

    public static ORecordSerializationContext pushContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        ORecordSerializationContext context = new ORecordSerializationContext();
        stack.push(context);
        return context;
    }

    public static ORecordSerializationContext getContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static ORecordSerializationContext pullContext() {
        Deque<ORecordSerializationContext> stack = SERIALIZATION_CONTEXT_STACK.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException("Can not find current serialization context");
        }
        return stack.poll();
    }

    public void push(ORecordSerializationOperation operation) {
        this.operations.push(operation);
    }

    void executeOperations(OLocalPaginatedStorage storage) {
        for (ORecordSerializationOperation operation : this.operations) {
            operation.execute(storage);
        }
    }
}

