/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.ONestedRollbackException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;

public class OAtomicOperationsManager {
    private static final ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<Object, OAtomicOperationsManager> lockManager = new OLockManager(true, 300000);

    public OAtomicOperationsManager(OWriteAheadLog writeAheadLog) {
        this.writeAheadLog = writeAheadLog;
    }

    public OAtomicOperation startAtomicOperation() throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            operation.incrementCounter();
            return operation;
        }
        OOperationUnitId unitId = OOperationUnitId.generateId();
        OLogSequenceNumber lsn = this.writeAheadLog.log(new OAtomicUnitStartRecord(true, unitId));
        operation = new OAtomicOperation(lsn, unitId);
        currentOperation.set(operation);
        return operation;
    }

    public OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    public OAtomicOperation endAtomicOperation(boolean rollback) throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        if (rollback) {
            operation.rollback();
        }
        if (operation.isRollback() && !rollback) {
            throw new ONestedRollbackException("Atomic operation was rolled back by internal component");
        }
        int counter = operation.decrementCounter();
        assert (counter >= 0);
        if (counter == 0) {
            for (Object lockObject : operation.lockedObjects()) {
                this.lockManager.releaseLock((Object)this, lockObject, OLockManager.LOCK.EXCLUSIVE);
            }
            this.writeAheadLog.log(new OAtomicUnitEndRecord(operation.getOperationUnitId(), rollback));
            currentOperation.set(null);
        }
        return operation;
    }

    public void lockTillOperationComplete(Object lockObject) {
        OAtomicOperation operation = currentOperation.get();
        if (operation == null) {
            return;
        }
        if (operation.containsInLockedObjects(lockObject)) {
            return;
        }
        this.lockManager.acquireLock((Object)this, lockObject, OLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(lockObject);
    }
}

