/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPageChanges;
import java.io.IOException;

public class ODurablePage {
    public static final int PAGE_PADDING = 8;
    protected static final int MAGIC_NUMBER_OFFSET = 0;
    protected static final int CRC32_OFFSET = 8;
    public static final int WAL_SEGMENT_OFFSET = 12;
    public static final int WAL_POSITION_OFFSET = 20;
    public static final int MAX_PAGE_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    protected static final int NEXT_FREE_POSITION = 28;
    protected OPageChanges pageChanges = new OPageChanges();
    private final OCacheEntry cacheEntry;
    private final ODirectMemoryPointer pagePointer;
    protected final TrackMode trackMode;

    public ODurablePage(OCacheEntry cacheEntry, TrackMode trackMode) {
        this.cacheEntry = cacheEntry;
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        this.pagePointer = cachePointer.getDataPointer();
        this.trackMode = trackMode;
    }

    public static OLogSequenceNumber getLogSequenceNumberFromPage(ODirectMemoryPointer dataPointer) {
        long segment = OLongSerializer.INSTANCE.deserializeFromDirectMemory(dataPointer, 20L);
        long position = OLongSerializer.INSTANCE.deserializeFromDirectMemory(dataPointer, 28L);
        return new OLogSequenceNumber(segment, position);
    }

    protected int getIntValue(int pageOffset) {
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(pageOffset + 8));
    }

    protected long getLongValue(int pageOffset) {
        return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(pageOffset + 8));
    }

    protected byte[] getBinaryValue(int pageOffset, int valLen) {
        return this.pagePointer.get((long)(pageOffset + 8), valLen);
    }

    protected int getObjectSizeInDirectMemory(OBinarySerializer binarySerializer, long offset) {
        return binarySerializer.getObjectSizeInDirectMemory(this.pagePointer, offset + 8L);
    }

    protected <T> T deserializeFromDirectMemory(OBinarySerializer<T> binarySerializer, long offset) {
        return (T)binarySerializer.deserializeFromDirectMemory(this.pagePointer, offset + 8L);
    }

    protected byte getByteValue(int pageOffset) {
        return this.pagePointer.getByte((long)(pageOffset + 8));
    }

    protected int setIntValue(int pageOffset, int value) throws IOException {
        if (this.trackMode.equals((Object)TrackMode.FULL)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), 4);
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
            byte[] newValues = this.pagePointer.get((long)(pageOffset + 8), 4);
            this.pageChanges.addChanges(pageOffset, newValues, oldValues);
        } else if (this.trackMode.equals((Object)TrackMode.ROLLBACK_ONLY)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), 4);
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
            this.pageChanges.addChanges(pageOffset, null, oldValues);
        } else {
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
        }
        this.cacheEntry.markDirty();
        return 4;
    }

    protected int setByteValue(int pageOffset, byte value) {
        if (this.trackMode.equals((Object)TrackMode.FULL)) {
            byte[] oldValues = new byte[]{this.pagePointer.getByte((long)(pageOffset + 8))};
            this.pagePointer.setByte((long)(pageOffset + 8), value);
            byte[] newValues = new byte[]{this.pagePointer.getByte((long)(pageOffset + 8))};
            this.pageChanges.addChanges(pageOffset, newValues, oldValues);
        } else if (this.trackMode.equals((Object)TrackMode.ROLLBACK_ONLY)) {
            byte[] oldValues = new byte[]{this.pagePointer.getByte((long)(pageOffset + 8))};
            this.pagePointer.setByte((long)(pageOffset + 8), value);
            this.pageChanges.addChanges(pageOffset, null, oldValues);
        } else {
            this.pagePointer.setByte((long)(pageOffset + 8), value);
        }
        this.cacheEntry.markDirty();
        return 1;
    }

    protected int setLongValue(int pageOffset, long value) throws IOException {
        if (this.trackMode.equals((Object)TrackMode.FULL)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), 8);
            OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
            byte[] newValues = this.pagePointer.get((long)(pageOffset + 8), 8);
            this.pageChanges.addChanges(pageOffset, newValues, oldValues);
        } else if (this.trackMode.equals((Object)TrackMode.ROLLBACK_ONLY)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), 8);
            OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
            this.pageChanges.addChanges(pageOffset, null, oldValues);
        } else {
            OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(value), this.pagePointer, (long)(pageOffset + 8), new Object[0]);
        }
        this.cacheEntry.markDirty();
        return 8;
    }

    protected int setBinaryValue(int pageOffset, byte[] value) throws IOException {
        if (value.length == 0) {
            return 0;
        }
        if (this.trackMode.equals((Object)TrackMode.FULL)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), value.length);
            this.pagePointer.set((long)(pageOffset + 8), value, 0, value.length);
            this.pageChanges.addChanges(pageOffset, value, oldValues);
        } else if (this.trackMode.equals((Object)TrackMode.ROLLBACK_ONLY)) {
            byte[] oldValues = this.pagePointer.get((long)(pageOffset + 8), value.length);
            this.pagePointer.set((long)(pageOffset + 8), value, 0, value.length);
            this.pageChanges.addChanges(pageOffset, null, oldValues);
        } else {
            this.pagePointer.set((long)(pageOffset + 8), value, 0, value.length);
        }
        this.cacheEntry.markDirty();
        return value.length;
    }

    protected void moveData(int from, int to, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.trackMode.equals((Object)TrackMode.FULL)) {
            byte[] content = this.pagePointer.get((long)(from + 8), len);
            byte[] oldContent = this.pagePointer.get((long)(to + 8), len);
            this.pagePointer.moveData((long)(from + 8), this.pagePointer, (long)(to + 8), (long)len);
            this.pageChanges.addChanges(to, content, oldContent);
        } else if (this.trackMode.equals((Object)TrackMode.ROLLBACK_ONLY)) {
            byte[] oldContent = this.pagePointer.get((long)(to + 8), len);
            this.pagePointer.moveData((long)(from + 8), this.pagePointer, (long)(to + 8), (long)len);
            this.pageChanges.addChanges(to, null, oldContent);
        } else {
            this.pagePointer.moveData((long)(from + 8), this.pagePointer, (long)(to + 8), (long)len);
        }
        this.cacheEntry.markDirty();
    }

    public OPageChanges getPageChanges() {
        return this.pageChanges;
    }

    public void restoreChanges(OPageChanges pageChanges) {
        pageChanges.applyChanges(this.pagePointer);
        this.cacheEntry.markDirty();
    }

    public void revertChanges(OPageChanges pageChanges) {
        pageChanges.revertChanges(this.pagePointer);
        this.cacheEntry.markDirty();
    }

    public OLogSequenceNumber getLsn() {
        long segment = this.getLongValue(12);
        long position = this.getLongValue(20);
        return new OLogSequenceNumber(segment, position);
    }

    public void setLsn(OLogSequenceNumber lsn) {
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(lsn.getSegment()), this.pagePointer, 20L, new Object[0]);
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(lsn.getPosition()), this.pagePointer, 28L, new Object[0]);
        this.cacheEntry.markDirty();
    }

    public static enum TrackMode {
        NONE,
        FULL,
        ROLLBACK_ONLY;

    }
}

