/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.util.HashSet;
import java.util.Set;

public class ODirtyPagesRecord
extends OAbstractWALRecord {
    private Set<ODirtyPage> dirtyPages;
    private final OBinarySerializer<String> stringSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(OType.STRING);

    public ODirtyPagesRecord() {
    }

    public ODirtyPagesRecord(Set<ODirtyPage> dirtyPages) {
        this.dirtyPages = dirtyPages;
    }

    public Set<ODirtyPage> getDirtyPages() {
        return this.dirtyPages;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.dirtyPages.size()), content, offset, new Object[0]);
        offset += 4;
        for (ODirtyPage dirtyPage : this.dirtyPages) {
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(dirtyPage.getPageIndex()), content, offset, new Object[0]);
            this.stringSerializer.serializeNative((Object)dirtyPage.getFileName(), content, offset += 8, new Object[0]);
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(dirtyPage.getLsn().getSegment()), content, offset += this.stringSerializer.getObjectSize((Object)dirtyPage.getFileName(), new Object[0]), new Object[0]);
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(dirtyPage.getLsn().getPosition()), content, offset += 8, new Object[0]);
            offset += 8;
        }
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        int size = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
        offset += 4;
        this.dirtyPages = new HashSet<ODirtyPage>();
        for (int i = 0; i < size; ++i) {
            long pageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset);
            String fileName = (String)this.stringSerializer.deserializeNative(content, offset += 8);
            long segment = OLongSerializer.INSTANCE.deserializeNative(content, offset += this.stringSerializer.getObjectSize((Object)fileName, new Object[0]));
            long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
            offset += 8;
            this.dirtyPages.add(new ODirtyPage(fileName, pageIndex, new OLogSequenceNumber(segment, position)));
        }
        return offset;
    }

    @Override
    public int serializedSize() {
        int size = 4;
        for (ODirtyPage dirtyPage : this.dirtyPages) {
            size += 24;
            size += this.stringSerializer.getObjectSize((Object)dirtyPage.getFileName(), new Object[0]);
        }
        return size;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODirtyPagesRecord that = (ODirtyPagesRecord)o;
        return this.dirtyPages.equals(that.dirtyPages);
    }

    @Override
    public int hashCode() {
        return this.dirtyPages.hashCode();
    }

    @Override
    public String toString() {
        return this.toString("dirtyPages=" + this.dirtyPages);
    }
}

