/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPagesRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecordsFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class OWriteAheadLog {
    public static final String MASTER_RECORD_EXTENSION = ".wmr";
    public static final String WAL_SEGMENT_EXTENSION = ".wal";
    private static final long ONE_KB = 1024L;
    private final Object syncObject = new Object();
    private final List<LogSegment> logSegments = new ArrayList<LogSegment>();
    private final int maxPagesCacheSize;
    private final int commitDelay;
    private final long maxSegmentSize;
    private final long maxLogSize;
    private final File walLocation;
    private final RandomAccessFile masterRecordLSNHolder;
    private final OStorageLocalAbstract storage;
    private OLogSequenceNumber lastCheckpoint;
    private boolean useFirstMasterRecord = true;
    private long logSize;
    private File masterRecordFile;
    private OLogSequenceNumber firstMasterRecord;
    private OLogSequenceNumber secondMasterRecord;
    private volatile OLogSequenceNumber flushedLsn;
    private boolean closed;

    public OWriteAheadLog(OStorageLocalAbstract storage) throws IOException {
        this(OGlobalConfiguration.WAL_CACHE_SIZE.getValueAsInteger(), OGlobalConfiguration.WAL_COMMIT_TIMEOUT.getValueAsInteger(), (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L, (long)OGlobalConfiguration.WAL_MAX_SIZE.getValueAsInteger() * 1024L * 1024L, storage);
    }

    public OWriteAheadLog(int maxPagesCacheSize, int commitDelay, long maxSegmentSize, long maxLogSize, OStorageLocalAbstract storage) throws IOException {
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitDelay = commitDelay;
        this.maxSegmentSize = maxSegmentSize;
        this.maxLogSize = maxLogSize;
        this.storage = storage;
        try {
            this.walLocation = new File(OWriteAheadLog.calculateWalPath(this.storage));
            File[] walFiles = this.walLocation.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return OWriteAheadLog.validateName(name);
                }
            });
            if (walFiles == null) {
                throw new IllegalStateException("Location passed in WAL does not exist, or IO error was happened. DB can not work in durable mode in such case.");
            }
            if (walFiles.length == 0) {
                LogSegment logSegment = new LogSegment(new File(this.walLocation, this.getSegmentName(0L)), maxPagesCacheSize);
                logSegment.init();
                logSegment.startFlush();
                this.logSegments.add(logSegment);
                this.logSize = 0L;
                this.flushedLsn = null;
            } else {
                this.logSize = 0L;
                for (File walFile : walFiles) {
                    LogSegment logSegment = new LogSegment(walFile, maxPagesCacheSize);
                    logSegment.init();
                    this.logSegments.add(logSegment);
                    this.logSize += logSegment.filledUpTo();
                }
                Collections.sort(this.logSegments);
                this.logSegments.get(this.logSegments.size() - 1).startFlush();
                this.flushedLsn = this.readFlushedLSN();
            }
            this.masterRecordFile = new File(this.walLocation, this.storage.getName() + MASTER_RECORD_EXTENSION);
            this.masterRecordLSNHolder = new RandomAccessFile(this.masterRecordFile, "rws");
            if (this.masterRecordLSNHolder.length() > 0L) {
                this.firstMasterRecord = this.readMasterRecord(this.storage.getName(), 0);
                this.secondMasterRecord = this.readMasterRecord(this.storage.getName(), 1);
                if (this.firstMasterRecord == null) {
                    this.useFirstMasterRecord = true;
                    this.lastCheckpoint = this.secondMasterRecord;
                } else if (this.secondMasterRecord == null) {
                    this.useFirstMasterRecord = false;
                    this.lastCheckpoint = this.firstMasterRecord;
                } else if (this.firstMasterRecord.compareTo(this.secondMasterRecord) >= 0) {
                    this.lastCheckpoint = this.firstMasterRecord;
                    this.useFirstMasterRecord = false;
                } else {
                    this.lastCheckpoint = this.secondMasterRecord;
                    this.useFirstMasterRecord = true;
                }
            }
            this.fixMasterRecords();
        }
        catch (FileNotFoundException e) {
            OLogManager.instance().error((Object)this, "Error during file initialization for storage %s", (Throwable)e, new Object[]{this.storage.getName()});
            throw new IllegalStateException("Error during file initialization for storage " + this.storage.getName(), e);
        }
    }

    private static String calculateWalPath(OStorageLocalAbstract storage) {
        String walPath = OGlobalConfiguration.WAL_LOCATION.getValueAsString();
        if (walPath == null) {
            walPath = storage.getStoragePath();
        }
        return walPath;
    }

    public static boolean validateName(String name) {
        if (!name.toLowerCase().endsWith(WAL_SEGMENT_EXTENSION)) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public File getWalLocation() {
        return this.walLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber begin() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            LogSegment first = this.logSegments.get(0);
            if (first.filledUpTo() == 0L) {
                return null;
            }
            return first.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber end() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            int lastIndex = this.logSegments.size() - 1;
            LogSegment last = this.logSegments.get(lastIndex);
            while (last.filledUpTo == 0L) {
                if (--lastIndex >= 0) {
                    last = this.logSegments.get(lastIndex);
                    continue;
                }
                return null;
            }
            return last.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            LogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            last.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber logFuzzyCheckPointStart() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            OFuzzyCheckpointStartRecord record = new OFuzzyCheckpointStartRecord(this.lastCheckpoint);
            this.log(record);
            return record.getLsn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber logFuzzyCheckPointEnd() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            OFuzzyCheckpointEndRecord record = new OFuzzyCheckpointEndRecord();
            this.log(record);
            return record.getLsn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber log(OWALRecord record) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            LogSegment first;
            this.checkForClose();
            byte[] serializedForm = OWALRecordsFactory.INSTANCE.toStream(record);
            LogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long lastSize = last.filledUpTo();
            OLogSequenceNumber lsn = last.logRecord(serializedForm);
            record.setLsn(lsn);
            if (record.isUpdateMasterRecord()) {
                this.lastCheckpoint = lsn;
                if (this.useFirstMasterRecord) {
                    this.firstMasterRecord = lsn;
                    this.writeMasterRecord(0, this.firstMasterRecord);
                    this.useFirstMasterRecord = false;
                } else {
                    this.secondMasterRecord = lsn;
                    this.writeMasterRecord(1, this.secondMasterRecord);
                    this.useFirstMasterRecord = true;
                }
            }
            long sizeDiff = last.filledUpTo() - lastSize;
            this.logSize += sizeDiff;
            if (this.logSize >= this.maxLogSize && (first = this.removeHeadSegmentFromList()) != null) {
                first.stopFlush(false);
                first.delete(false);
                this.recalculateLogSize();
                this.fixMasterRecords();
            }
            if (last.filledUpTo() >= this.maxSegmentSize) {
                last.stopFlush(true);
                last = new LogSegment(new File(this.walLocation, this.getSegmentName(last.getOrder() + 1L)), this.maxPagesCacheSize);
                last.init();
                last.startFlush();
                this.logSegments.add(last);
            }
            return lsn;
        }
    }

    private void recalculateLogSize() throws IOException {
        this.logSize = 0L;
        for (LogSegment segment : this.logSegments) {
            this.logSize += segment.filledUpTo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.logSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.logSegments.size() < 2) {
                return;
            }
            ListIterator<LogSegment> iterator = this.logSegments.listIterator(this.logSegments.size() - 1);
            while (iterator.hasPrevious()) {
                LogSegment logSegment = iterator.previous();
                logSegment.delete(false);
                iterator.remove();
            }
            this.recalculateLogSize();
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (LogSegment logSegment : this.logSegments) {
                logSegment.close(flush);
            }
            this.masterRecordLSNHolder.close();
        }
    }

    public void delete() throws IOException {
        this.delete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.close(flush);
            for (LogSegment logSegment : this.logSegments) {
                logSegment.delete(false);
            }
            boolean deleted = this.masterRecordFile.delete();
            while (!deleted) {
                OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                deleted = !this.masterRecordFile.exists() || this.masterRecordFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyPages(Set<ODirtyPage> dirtyPages) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            this.log(new ODirtyPagesRecord(dirtyPages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber getLastCheckpoint() {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            return this.lastCheckpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWALRecord read(OLogSequenceNumber lsn) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            long segment = lsn.getSegment();
            int index = (int)(segment - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                return null;
            }
            LogSegment logSegment = this.logSegments.get(index);
            byte[] recordEntry = logSegment.readRecord(lsn);
            if (recordEntry == null) {
                return null;
            }
            OWALRecord record = OWALRecordsFactory.INSTANCE.fromStream(recordEntry);
            record.setLsn(lsn);
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber next(OLogSequenceNumber lsn) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            long order = lsn.getSegment();
            int index = (int)(order - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                return null;
            }
            LogSegment logSegment = this.logSegments.get(index);
            OLogSequenceNumber nextLSN = logSegment.getNextLSN(lsn);
            if (nextLSN == null) {
                if (++index >= this.logSegments.size()) {
                    return null;
                }
                LogSegment nextSegment = this.logSegments.get(index);
                if (nextSegment.filledUpTo() == 0L) {
                    return null;
                }
                nextLSN = nextSegment.begin();
            }
            return nextLSN;
        }
    }

    public OLogSequenceNumber getFlushedLSN() {
        return this.flushedLsn;
    }

    public OLogSequenceNumber logFullCheckpointStart() throws IOException {
        return this.log(new OFullCheckpointStartRecord(this.lastCheckpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber logFullCheckpointEnd() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkForClose();
            return this.log(new OCheckpointEndRecord());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cutTill(OLogSequenceNumber lsn) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            LogSegment logSegment;
            this.checkForClose();
            this.flush();
            int lastTruncateIndex = -1;
            int i = 0;
            while (i < this.logSegments.size() - 1 && (logSegment = this.logSegments.get(i)).end().compareTo(lsn) < 0) {
                lastTruncateIndex = i++;
            }
            for (i = 0; i <= lastTruncateIndex; ++i) {
                logSegment = this.removeHeadSegmentFromList();
                if (logSegment == null) continue;
                logSegment.delete(false);
            }
            this.recalculateLogSize();
        }
    }

    private LogSegment removeHeadSegmentFromList() {
        if (this.logSegments.size() < 2) {
            return null;
        }
        return this.logSegments.remove(0);
    }

    private void fixMasterRecords() throws IOException {
        int index;
        if (this.firstMasterRecord != null) {
            index = (int)(this.firstMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.firstMasterRecord = null;
            } else {
                LogSegment firstMasterRecordSegment = this.logSegments.get(index);
                if (firstMasterRecordSegment.filledUpTo() <= this.firstMasterRecord.getPosition()) {
                    this.firstMasterRecord = null;
                }
            }
        }
        if (this.secondMasterRecord != null) {
            index = (int)(this.secondMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.secondMasterRecord = null;
            } else {
                LogSegment secondMasterRecordSegment = this.logSegments.get(index);
                if (secondMasterRecordSegment.filledUpTo() <= this.secondMasterRecord.getPosition()) {
                    this.secondMasterRecord = null;
                }
            }
        }
        if (this.firstMasterRecord != null && this.secondMasterRecord != null) {
            return;
        }
        if (this.firstMasterRecord == null && this.secondMasterRecord == null) {
            this.masterRecordLSNHolder.setLength(0L);
            this.masterRecordLSNHolder.getFD().sync();
            this.lastCheckpoint = null;
        } else {
            if (this.secondMasterRecord == null) {
                this.secondMasterRecord = this.firstMasterRecord;
            } else {
                this.firstMasterRecord = this.secondMasterRecord;
            }
            this.lastCheckpoint = this.firstMasterRecord;
            this.writeMasterRecord(0, this.firstMasterRecord);
            this.writeMasterRecord(1, this.secondMasterRecord);
        }
    }

    private OLogSequenceNumber readMasterRecord(String storageName, int index) throws IOException {
        CRC32 crc32 = new CRC32();
        try {
            this.masterRecordLSNHolder.seek(index * 20);
            int firstCRC = this.masterRecordLSNHolder.readInt();
            long segment = this.masterRecordLSNHolder.readLong();
            long position = this.masterRecordLSNHolder.readLong();
            byte[] serializedLSN = new byte[16];
            OLongSerializer.INSTANCE.serialize(Long.valueOf(segment), serializedLSN, 0, new Object[0]);
            OLongSerializer.INSTANCE.serialize(Long.valueOf(position), serializedLSN, 8, new Object[0]);
            crc32.update(serializedLSN);
            if (firstCRC != (int)crc32.getValue()) {
                OLogManager.instance().error((Object)this, "Can not restore %d WAL master record for storage %s crc check is failed", new Object[]{index, storageName});
                return null;
            }
            return new OLogSequenceNumber(segment, position);
        }
        catch (EOFException eofException) {
            OLogManager.instance().debug((Object)this, "Can not restore %d WAL master record for storage %s", new Object[]{index, storageName});
            return null;
        }
    }

    private void writeMasterRecord(int index, OLogSequenceNumber masterRecord) throws IOException {
        this.masterRecordLSNHolder.seek(index * 20);
        CRC32 crc32 = new CRC32();
        byte[] serializedLSN = new byte[16];
        OLongSerializer.INSTANCE.serialize(Long.valueOf(masterRecord.getSegment()), serializedLSN, 0, new Object[0]);
        OLongSerializer.INSTANCE.serialize(Long.valueOf(masterRecord.getPosition()), serializedLSN, 8, new Object[0]);
        crc32.update(serializedLSN);
        this.masterRecordLSNHolder.writeInt((int)crc32.getValue());
        this.masterRecordLSNHolder.writeLong(masterRecord.getSegment());
        this.masterRecordLSNHolder.writeLong(masterRecord.getPosition());
    }

    private String getSegmentName(long order) {
        return this.storage.getName() + "." + order + WAL_SEGMENT_EXTENSION;
    }

    private void checkForClose() {
        if (this.closed) {
            throw new OStorageException("WAL log " + this.walLocation + " has been closed");
        }
    }

    private OLogSequenceNumber readFlushedLSN() throws IOException {
        for (int segment = this.logSegments.size() - 1; segment >= 0; --segment) {
            LogSegment logSegment = this.logSegments.get(segment);
            OLogSequenceNumber flushedLSN = logSegment.readFlushedLSN();
            if (flushedLSN == null) {
                continue;
            }
            return flushedLSN;
        }
        return null;
    }

    private final class LogSegment
    implements Comparable<LogSegment> {
        private final RandomAccessFile rndFile;
        private final File file;
        private final long order;
        private final int maxPagesCacheSize;
        private final ConcurrentLinkedQueue<OWALPage> pagesCache = new ConcurrentLinkedQueue();
        private final ScheduledExecutorService commitExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("OrientDB WAL Flush Task (" + OWriteAheadLog.this.storage.getName() + ")");
                return thread;
            }
        });
        private long filledUpTo;
        private boolean closed;
        private OWALPage currentPage;
        private long nextPositionToFlush;
        private OLogSequenceNumber last = null;
        private OLogSequenceNumber pendingLSNToFlush;
        private volatile boolean flushNewData = true;
        private WeakReference<OPair<OLogSequenceNumber, byte[]>> lastReadRecord = new WeakReference<Object>(null);

        private LogSegment(File file, int maxPagesCacheSize) throws IOException {
            this.file = file;
            this.maxPagesCacheSize = maxPagesCacheSize;
            this.order = this.extractOrder(file.getName());
            this.closed = false;
            this.rndFile = new RandomAccessFile(file, "rw");
        }

        public void startFlush() {
            if (OWriteAheadLog.this.commitDelay > 0) {
                this.commitExecutor.scheduleAtFixedRate(new FlushTask(), OWriteAheadLog.this.commitDelay, OWriteAheadLog.this.commitDelay, TimeUnit.MILLISECONDS);
            }
        }

        public void stopFlush(boolean flush) {
            if (flush) {
                this.flush();
            }
            if (!this.commitExecutor.isShutdown()) {
                this.commitExecutor.shutdown();
                try {
                    if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL flush task for " + this.getPath() + " segment can not be stopped.");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "Can not shutdown background WAL commit thread.", new Object[0]);
                }
            }
        }

        public long getOrder() {
            return this.order;
        }

        public void init() throws IOException {
            this.selfCheck();
            this.initPageCache();
            this.last = new OLogSequenceNumber(this.order, this.filledUpTo - 1L);
        }

        @Override
        public int compareTo(LogSegment other) {
            long otherOrder = other.order;
            if (this.order > otherOrder) {
                return 1;
            }
            if (this.order < otherOrder) {
                return -1;
            }
            return 0;
        }

        public long filledUpTo() throws IOException {
            return this.filledUpTo;
        }

        public OLogSequenceNumber begin() throws IOException {
            if (!this.pagesCache.isEmpty()) {
                return new OLogSequenceNumber(this.order, 16L);
            }
            if (this.rndFile.length() > 0L) {
                return new OLogSequenceNumber(this.order, 16L);
            }
            return null;
        }

        public OLogSequenceNumber end() {
            return this.last;
        }

        public void delete(boolean flush) throws IOException {
            this.close(flush);
            boolean deleted = OFileUtils.delete((File)this.file);
            int retryCount = 0;
            while (!deleted) {
                OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                deleted = OFileUtils.delete((File)this.file);
                if (++retryCount <= 10) continue;
                throw new IOException("Can not delete file. Retry limit exceeded. (" + retryCount + ").");
            }
        }

        public String getPath() {
            return this.file.getAbsolutePath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OLogSequenceNumber logRecord(byte[] record) throws IOException {
            this.flushNewData = true;
            int pageOffset = (int)(this.filledUpTo % 65536L);
            long pageIndex = this.filledUpTo / 65536L;
            if (pageOffset == 0 && pageIndex > 0L) {
                --pageIndex;
            }
            int pos = 0;
            boolean firstChunk = true;
            OLogSequenceNumber lsn = null;
            while (pos < record.length) {
                OWALPage walPage;
                int freeSpace;
                if (this.currentPage == null) {
                    ODirectMemoryPointer pointer = new ODirectMemoryPointer(65536L);
                    this.currentPage = new OWALPage(pointer, true);
                    this.pagesCache.add(this.currentPage);
                    this.filledUpTo += 16L;
                }
                if ((freeSpace = this.currentPage.getFreeSpace()) < 7) {
                    this.filledUpTo += (long)(freeSpace + 16);
                    ODirectMemoryPointer pointer = new ODirectMemoryPointer(65536L);
                    this.currentPage = new OWALPage(pointer, true);
                    this.pagesCache.add(this.currentPage);
                    ++pageIndex;
                    freeSpace = this.currentPage.getFreeSpace();
                }
                OWALPage oWALPage = walPage = this.currentPage;
                synchronized (oWALPage) {
                    int addedChunkOffset;
                    int entrySize = OWALPage.calculateSerializedSize(record.length - pos);
                    if (entrySize <= freeSpace) {
                        addedChunkOffset = pos == 0 ? walPage.appendRecord(record, false, !firstChunk) : walPage.appendRecord(Arrays.copyOfRange(record, pos, record.length), false, !firstChunk);
                        pos = record.length;
                    } else {
                        int chunkSize = OWALPage.calculateRecordSize(freeSpace);
                        if (chunkSize > record.length - pos) {
                            chunkSize = record.length - pos;
                        }
                        addedChunkOffset = walPage.appendRecord(Arrays.copyOfRange(record, pos, pos + chunkSize), true, !firstChunk);
                        pos += chunkSize;
                    }
                    if (firstChunk) {
                        lsn = new OLogSequenceNumber(this.order, pageIndex * 65536L + (long)addedChunkOffset);
                    }
                    int spaceDiff = freeSpace - walPage.getFreeSpace();
                    this.filledUpTo += (long)spaceDiff;
                    firstChunk = false;
                }
            }
            if (this.pagesCache.size() > this.maxPagesCacheSize) {
                OLogManager.instance().info((Object)this, "Max cache limit is reached (%d vs. %d), sync flush is performed.", new Object[]{this.maxPagesCacheSize, this.pagesCache.size()});
                this.flush();
            }
            this.last = lsn;
            return this.last;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
            OPair lastRecord = (OPair)this.lastReadRecord.get();
            if (lastRecord != null && ((OLogSequenceNumber)lastRecord.getKey()).equals(lsn)) {
                return (byte[])lastRecord.getValue();
            }
            assert (lsn.getSegment() == this.order);
            if (lsn.getPosition() >= this.filledUpTo) {
                return null;
            }
            if (!this.pagesCache.isEmpty()) {
                this.flush();
            }
            long pageIndex = lsn.getPosition() / 65536L;
            byte[] record = null;
            int pageOffset = (int)(lsn.getPosition() % 65536L);
            long pageCount = (this.filledUpTo + 65536L - 1L) / 65536L;
            while (pageIndex < pageCount) {
                byte[] pageContent = new byte[65536];
                RandomAccessFile randomAccessFile = this.rndFile;
                synchronized (randomAccessFile) {
                    this.rndFile.seek(pageIndex * 65536L);
                    this.rndFile.readFully(pageContent);
                }
                if (!this.checkPageIntegrity(pageContent)) {
                    throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken.");
                }
                ODirectMemoryPointer pointer = new ODirectMemoryPointer(pageContent);
                try {
                    OWALPage page = new OWALPage(pointer, false);
                    byte[] content = page.getRecord(pageOffset);
                    if (record == null) {
                        record = content;
                    } else {
                        byte[] oldRecord = record;
                        record = new byte[record.length + content.length];
                        System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                        System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
                    }
                    if (page.mergeWithNextPage(pageOffset)) {
                        pageOffset = 16;
                        if (++pageIndex < pageCount) continue;
                        throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken.");
                    }
                    if (page.getFreeSpace() >= 7 && pageIndex < pageCount - 1L) {
                        throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken.");
                    }
                    break;
                }
                finally {
                    pointer.free();
                }
            }
            this.lastReadRecord = new WeakReference<OPair>(new OPair((Comparable)lsn, record));
            return record;
        }

        public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
            byte[] record = this.readRecord(lsn);
            if (record == null) {
                return null;
            }
            long pos = lsn.getPosition();
            long pageIndex = pos / 65536L;
            int pageOffset = (int)(pos - pageIndex * 65536L);
            int restOfRecord = record.length;
            while (restOfRecord > 0) {
                int entrySize = OWALPage.calculateSerializedSize(restOfRecord);
                if (entrySize + pageOffset < 65536) {
                    if (entrySize + pageOffset <= 65529) {
                        pos += (long)entrySize;
                        break;
                    }
                    pos += (long)(65536 - pageOffset + 16);
                    break;
                }
                if (entrySize + pageOffset == 65536) {
                    pos += (long)(entrySize + 16);
                    break;
                }
                int chunkSize = OWALPage.calculateRecordSize(65536 - pageOffset);
                restOfRecord -= chunkSize;
                pos += (long)(65536 - pageOffset + 16);
                pageOffset = 16;
            }
            if (pos >= this.filledUpTo) {
                return null;
            }
            return new OLogSequenceNumber(this.order, pos);
        }

        public void close(boolean flush) throws IOException {
            if (!this.closed) {
                this.lastReadRecord.clear();
                this.stopFlush(flush);
                this.rndFile.close();
                this.closed = true;
                if (!this.pagesCache.isEmpty()) {
                    for (OWALPage page : this.pagesCache) {
                        page.getPagePointer().free();
                    }
                }
                this.currentPage = null;
            }
        }

        public OLogSequenceNumber readFlushedLSN() throws IOException {
            long pages = this.rndFile.length() / 65536L;
            if (pages == 0L) {
                return null;
            }
            return new OLogSequenceNumber(this.order, this.filledUpTo - 1L);
        }

        public void flush() {
            if (!this.commitExecutor.isShutdown()) {
                try {
                    this.commitExecutor.submit(new FlushTask()).get();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new OStorageException("Thread was interrupted during flush", e);
                }
                catch (ExecutionException e) {
                    throw new OStorageException("Error during WAL segment " + this.getPath() + " flush.");
                }
            } else {
                new FlushTask().run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initPageCache() throws IOException {
            RandomAccessFile randomAccessFile = this.rndFile;
            synchronized (randomAccessFile) {
                long pagesCount = this.rndFile.length() / 65536L;
                if (pagesCount == 0L) {
                    return;
                }
                this.rndFile.seek((pagesCount - 1L) * 65536L);
                byte[] content = new byte[65536];
                this.rndFile.readFully(content);
                if (this.checkPageIntegrity(content)) {
                    ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
                    this.currentPage = new OWALPage(pointer, false);
                    this.filledUpTo = (pagesCount - 1L) * 65536L + (long)this.currentPage.getFilledUpTo();
                    this.nextPositionToFlush = (pagesCount - 1L) * 65536L;
                } else {
                    ODirectMemoryPointer pointer = new ODirectMemoryPointer(65536L);
                    this.currentPage = new OWALPage(pointer, true);
                    this.filledUpTo = pagesCount * 65536L + (long)this.currentPage.getFilledUpTo();
                    this.nextPositionToFlush = pagesCount * 65536L;
                }
                this.pagesCache.add(this.currentPage);
            }
        }

        private long extractOrder(String name) {
            Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
            boolean matches = matcher.find();
            assert (matches);
            String order = matcher.group(1);
            try {
                return Long.parseLong(order);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean checkPageIntegrity(byte[] content) {
            long magicNumber = OLongSerializer.INSTANCE.deserializeNative(content, 4);
            if (magicNumber != 4207608830L) {
                return false;
            }
            CRC32 crc32 = new CRC32();
            crc32.update(content, 4, 65532);
            return (int)crc32.getValue() == OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selfCheck() throws IOException {
            if (!this.pagesCache.isEmpty()) {
                throw new IllegalStateException("WAL cache is not empty, we can not verify WAL after it was started to be used");
            }
            RandomAccessFile randomAccessFile = this.rndFile;
            synchronized (randomAccessFile) {
                long pagesCount = this.rndFile.length() / 65536L;
                if (this.rndFile.length() % 65536L > 0L) {
                    OLogManager.instance().error((Object)this, "Last WAL page was written partially, auto fix.", new Object[0]);
                    this.rndFile.setLength(65536L * pagesCount);
                }
            }
        }

        private final class FlushTask
        implements Runnable {
            private FlushTask() {
            }

            @Override
            public void run() {
                try {
                    this.commit();
                }
                catch (Throwable e) {
                    OLogManager.instance().error((Object)this, "Error during WAL background flush", e, new Object[0]);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void commit() throws IOException {
                Object page;
                int flushedPages;
                if (LogSegment.this.pagesCache.isEmpty()) {
                    return;
                }
                if (!LogSegment.this.flushNewData) {
                    return;
                }
                LogSegment.this.flushNewData = false;
                int maxSize = LogSegment.this.pagesCache.size();
                ODirectMemoryPointer[] pagesToFlush = new ODirectMemoryPointer[maxSize];
                long filePointer = LogSegment.this.nextPositionToFlush;
                OLogSequenceNumber lastLSNToFlush = null;
                Iterator pageIterator = LogSegment.this.pagesCache.iterator();
                for (flushedPages = 0; flushedPages < maxSize; ++flushedPages) {
                    page = (OWALPage)pageIterator.next();
                    OWALPage oWALPage = page;
                    synchronized (oWALPage) {
                        ODirectMemoryPointer dataPointer;
                        int filledUpTo = ((OWALPage)page).getFilledUpTo();
                        for (int pos = 16; pos < filledUpTo; pos += ((OWALPage)page).getSerializedRecordSize(pos)) {
                            if (!((OWALPage)page).mergeWithNextPage(pos)) {
                                if (pos == 16 && LogSegment.this.pendingLSNToFlush != null) {
                                    lastLSNToFlush = LogSegment.this.pendingLSNToFlush;
                                    LogSegment.this.pendingLSNToFlush = null;
                                    continue;
                                }
                                lastLSNToFlush = new OLogSequenceNumber(LogSegment.this.order, filePointer + (long)(flushedPages * 65536) + (long)pos);
                                continue;
                            }
                            if (LogSegment.this.pendingLSNToFlush != null) continue;
                            LogSegment.this.pendingLSNToFlush = new OLogSequenceNumber(LogSegment.this.order, filePointer + (long)(flushedPages * 65536) + (long)pos);
                        }
                        if (flushedPages == maxSize - 1) {
                            dataPointer = new ODirectMemoryPointer(65536L);
                            ((OWALPage)page).getPagePointer().moveData(0L, dataPointer, 0L, 65536L);
                        } else {
                            dataPointer = ((OWALPage)page).getPagePointer();
                        }
                        pagesToFlush[flushedPages] = dataPointer;
                        continue;
                    }
                }
                page = LogSegment.this.rndFile;
                synchronized (page) {
                    LogSegment.this.rndFile.seek(filePointer);
                    for (int i = 0; i < pagesToFlush.length; ++i) {
                        ODirectMemoryPointer dataPointer = pagesToFlush[i];
                        byte[] pageContent = dataPointer.get(0L, 65536);
                        if (i == pagesToFlush.length - 1) {
                            dataPointer.free();
                        }
                        this.flushPage(pageContent);
                        filePointer += 65536L;
                    }
                    if (OGlobalConfiguration.WAL_SYNC_ON_PAGE_FLUSH.getValueAsBoolean()) {
                        LogSegment.this.rndFile.getFD().sync();
                    }
                }
                LogSegment.this.nextPositionToFlush = filePointer - 65536L;
                if (lastLSNToFlush != null) {
                    OWriteAheadLog.this.flushedLsn = lastLSNToFlush;
                }
                for (int i = 0; i < flushedPages - 1; ++i) {
                    OWALPage page2 = (OWALPage)LogSegment.this.pagesCache.poll();
                    page2.getPagePointer().free();
                }
                assert (!LogSegment.this.pagesCache.isEmpty());
            }

            private void flushPage(byte[] content) throws IOException {
                CRC32 crc32 = new CRC32();
                crc32.update(content, 4, 65532);
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), content, 0, new Object[0]);
                LogSegment.this.rndFile.write(content);
            }
        }
    }
}

