/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.HashMap;
import java.util.Map;

public abstract class OTransactionAbstract
implements OTransaction {
    protected final ODatabaseRecordTx database;
    protected OTransaction.TXSTATUS status = OTransaction.TXSTATUS.INVALID;
    protected HashMap<ORID, OStorage.LOCKING_STRATEGY> locks = new HashMap();

    protected OTransactionAbstract(ODatabaseRecordTx iDatabase) {
        this.database = iDatabase;
    }

    public static void updateCacheFromEntries(OTransaction tx, Iterable<? extends ORecordOperation> entries, boolean updateStrategy) {
        OLevel1RecordCache dbCache = tx.getDatabase().getLevel1Cache();
        for (ORecordOperation oRecordOperation : entries) {
            if (!updateStrategy) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
                continue;
            }
            if (oRecordOperation.type == 2) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
                continue;
            }
            if (oRecordOperation.type != 1 && oRecordOperation.type != 3) continue;
            dbCache.updateRecord(oRecordOperation.getRecord());
        }
    }

    @Override
    public boolean isActive() {
        return this.status != OTransaction.TXSTATUS.INVALID && this.status != OTransaction.TXSTATUS.COMPLETED && this.status != OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public OTransaction.TXSTATUS getStatus() {
        return this.status;
    }

    @Override
    public ODatabaseRecordTx getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        for (Map.Entry<ORID, OStorage.LOCKING_STRATEGY> lock : this.locks.entrySet()) {
            try {
                if (lock.getValue().equals((Object)OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK)) {
                    ((OStorageEmbedded)this.getDatabase().getStorage()).releaseWriteLock(lock.getKey());
                    continue;
                }
                if (!lock.getValue().equals((Object)OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK)) continue;
                ((OStorageEmbedded)this.getDatabase().getStorage()).releaseReadLock(lock.getKey());
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on releasing lock against record " + lock.getKey(), new Object[0]);
            }
        }
        this.locks.clear();
    }

    @Override
    public OTransaction lockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        OStorage stg = this.database.getStorage();
        if (!(stg.getUnderlying() instanceof OStorageEmbedded)) {
            throw new OLockException("Cannot lock record across remote connections");
        }
        ORID rid = iRecord.getIdentity();
        if (iLockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
            ((OStorageEmbedded)stg.getUnderlying()).acquireWriteLock(rid);
        } else {
            ((OStorageEmbedded)stg.getUnderlying()).acquireReadLock(rid);
        }
        this.locks.put(rid, iLockingStrategy);
        return this;
    }

    @Override
    public OTransaction unlockRecord(OIdentifiable iRecord) {
        OStorage stg = this.database.getStorage();
        if (!(stg.getUnderlying() instanceof OStorageEmbedded)) {
            throw new OLockException("Cannot lock record across remote connections");
        }
        ORID rid = iRecord.getIdentity();
        OStorage.LOCKING_STRATEGY lock = this.locks.remove(rid);
        if (lock == null) {
            throw new OLockException("Cannot unlock a never acquired lock");
        }
        if (lock == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
            ((OStorageEmbedded)stg.getUnderlying()).releaseWriteLock(rid);
        } else {
            ((OStorageEmbedded)stg.getUnderlying()).releaseReadLock(rid);
        }
        return this;
    }

    @Override
    public HashMap<ORID, OStorage.LOCKING_STRATEGY> getLockedRecords() {
        return this.locks;
    }

    protected void invokeCommitAgainstListeners() {
        for (ODatabaseListener listener : ((ODatabaseRaw)this.database.getUnderlying()).browseListeners()) {
            try {
                listener.onBeforeTxCommit((ODatabase)this.database.getUnderlying());
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error on commit callback against listener: " + listener, t, new Object[0]);
            }
        }
    }

    protected void invokeRollbackAgainstListeners() {
        for (ODatabaseListener listener : ((ODatabaseRaw)this.database.getUnderlying()).browseListeners()) {
            try {
                listener.onBeforeTxRollback((ODatabase)this.database.getUnderlying());
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error on rollback callback against listener: " + listener, t, new Object[0]);
            }
        }
    }
}

