/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.Collection;
import java.util.List;

public class OTransactionNoTx
extends OTransactionAbstract {
    public OTransactionNoTx(ODatabaseRecordTx iDatabase) {
        super(iDatabase);
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public int getEntryCount() {
        return 0;
    }

    @Override
    public void commit(boolean force) {
    }

    @Override
    public void rollback() {
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean ignonreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        if (iRid.isNew()) {
            return null;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, ignonreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        try {
            this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getRecordVersion(), true, iMode, iForceCreate, iRecordCreatedCallback, null);
        }
        catch (Exception e) {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (rid.isValid()) {
                this.database.getLevel1Cache().freeRecord(rid);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OException((Throwable)e);
        }
    }

    @Override
    public boolean updateReplica(ORecordInternal<?> iRecord) {
        try {
            return this.database.executeUpdateReplica(iRecord);
        }
        catch (Exception e) {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            this.database.getLevel1Cache().freeRecord(rid);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OException((Throwable)e);
        }
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isPersistent()) {
            return;
        }
        try {
            this.database.executeDeleteRecord(iRecord, iRecord.getRecordVersion(), true, true, iMode, false);
        }
        catch (Exception e) {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (rid.isValid()) {
                this.database.getLevel1Cache().freeRecord(rid);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OException((Throwable)e);
        }
    }

    public Collection<ORecordOperation> getCurrentRecordEntries() {
        return null;
    }

    public Collection<ORecordOperation> getAllRecordEntries() {
        return null;
    }

    @Override
    public List<ORecordOperation> getRecordEntriesByClass(String iClassName) {
        return null;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] iIds) {
        return null;
    }

    @Override
    public void clearRecordEntries() {
    }

    public int getRecordEntriesSize() {
        return 0;
    }

    @Override
    public ORecordInternal<?> getRecord(ORID rid) {
        return null;
    }

    @Override
    public ORecordOperation getRecordEntry(ORID rid) {
        return null;
    }

    @Override
    public boolean isUsingLog() {
        return false;
    }

    @Override
    public void setUsingLog(boolean useLog) {
    }

    @Override
    public ODocument getIndexChanges() {
        return null;
    }

    public OTransactionIndexChangesPerKey getIndexEntry(String iIndexName, Object iKey) {
        return null;
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String indexName, OTransactionIndexChanges.OPERATION status, Object key, OIdentifiable value) {
        switch (status) {
            case CLEAR: {
                delegate.clear();
                break;
            }
            case PUT: {
                delegate.put(key, value);
                break;
            }
            case REMOVE: {
                assert (key != null);
                delegate.remove(key, value);
            }
        }
    }

    @Override
    public void clearIndexEntries() {
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String iName) {
        return null;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public List<String> getInvolvedIndexes() {
        return null;
    }

    @Override
    public void updateIdentityAfterCommit(ORID oldRid, ORID newRid) {
    }

    @Override
    public int amountOfNestedTxs() {
        return 0;
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
    }
}

