/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type;

import com.orientechnologies.common.io.OIOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OBuffer
implements Externalizable {
    public byte[] buffer;

    public OBuffer() {
    }

    public OBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        int bufferLenght = iInput.readInt();
        if (bufferLenght > 0) {
            this.buffer = new byte[bufferLenght];
            int bytesReaded = 0;
            for (int pos = 0; pos < bufferLenght; pos += bytesReaded) {
                bytesReaded = iInput.read(this.buffer, pos, this.buffer.length - pos);
            }
        } else {
            this.buffer = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        int bufferLenght = this.buffer != null ? this.buffer.length : 0;
        iOutput.writeInt(bufferLenght);
        if (bufferLenght > 0) {
            iOutput.write(this.buffer);
        }
    }

    public String toString() {
        return "size:" + (this.buffer != null ? Integer.valueOf(this.buffer.length) : "empty");
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OBuffer)) {
            return false;
        }
        return OIOUtils.equals((byte[])this.buffer, (byte[])((OBuffer)o).buffer);
    }
}

