/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapProvider;
import java.util.HashSet;
import java.util.Set;

public class OMVRBTreeDatabase<K, V>
extends OMVRBTreePersistent<K, V> {
    public OMVRBTreeDatabase(ODatabaseRecord iDatabase, ORID iRID) {
        super(new OMVRBTreeMapProvider(null, iDatabase.getClusterNameById(iRID.getClusterId()), iRID));
    }

    public OMVRBTreeDatabase(String iClusterName, OBinarySerializer<K> iKeySerializer, OStreamSerializer iValueSerializer, int keySize) {
        super(new OMVRBTreeMapProvider(null, iClusterName, iKeySerializer, iValueSerializer), keySize);
    }

    public void onAfterTxCommit() {
        Set<ORID> nodesInMemory = this.getAllNodesInCache();
        if (nodesInMemory.isEmpty()) {
            return;
        }
        HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
        for (ORID rid : keys) {
            if (!rid.getClusterPosition().isTemporary()) continue;
            OMVRBTreeEntryPersistent entry = this.searchNodeInCache(rid);
            this.removeNodeFromCache(rid);
            this.addNodeInCache(entry);
        }
    }
}

