/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabase;

public class OMVRBTreeDatabaseLazySave<K, V>
extends OMVRBTreeDatabase<K, V> {
    protected int maxUpdatesBeforeSave;
    protected int updates = 0;
    protected boolean transactionRunning = false;

    public OMVRBTreeDatabaseLazySave(ODatabaseRecord iDatabase, ORID iRID, int iMaxUpdatesBeforeSave) {
        super(iDatabase, iRID);
        this.maxUpdatesBeforeSave = iMaxUpdatesBeforeSave;
    }

    public OMVRBTreeDatabaseLazySave(String iClusterName, OBinarySerializer<K> iKeySerializer, OStreamSerializer iValueSerializer, int keySize, int iMaxUpdatesBeforeSave) {
        super(iClusterName, iKeySerializer, iValueSerializer, keySize);
        this.maxUpdatesBeforeSave = iMaxUpdatesBeforeSave;
    }

    @Override
    public synchronized int commitChanges() {
        return this.commitChanges(false);
    }

    public synchronized int commitChanges(boolean force) {
        if (this.transactionRunning || this.maxUpdatesBeforeSave == 0 || this.maxUpdatesBeforeSave > 0 && ++this.updates >= this.maxUpdatesBeforeSave || force) {
            this.updates = 0;
            return this.lazySave();
        }
        return 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.lazySave();
    }

    public int lazySave() {
        return super.commitChanges();
    }

    @Override
    public int optimize(boolean iForce) {
        if (this.optimization == -1) {
            return 0;
        }
        if (!iForce && this.optimization == 0) {
            return 0;
        }
        this.optimization = iForce ? 2 : 1;
        this.lazySave();
        return super.optimize(iForce);
    }

    public int getMaxUpdatesBeforeSave() {
        return this.maxUpdatesBeforeSave;
    }

    public void setMaxUpdatesBeforeSave(int iValue) {
        this.maxUpdatesBeforeSave = iValue;
    }

    public void setRunningTransaction(boolean iTxRunning) {
        this.transactionRunning = iTxRunning;
        if (iTxRunning) {
            this.updates = 0;
            this.lazySave();
        }
    }
}

