/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OLazyRecordMultiIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.mvrbtree.OMVRBTreeEntry;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDEntryProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OMVRBTreeRID
extends OMVRBTreePersistent<OIdentifiable, OIdentifiable>
implements OTrackedMultiValue<OIdentifiable, OIdentifiable>,
ORecordLazyMultiValue {
    private IdentityHashMap<ORecord<?>, Object> newEntries;
    private boolean autoConvertToRecord = true;
    private Set<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners = Collections.newSetFromMap(new WeakHashMap());
    private static final Object NEWMAP_VALUE = new Object();
    private static final long serialVersionUID = 1L;
    private boolean marshalling;

    public OMVRBTreeRID(Collection<OIdentifiable> iInitValues) {
        this();
        this.putAll(iInitValues);
    }

    public OMVRBTreeRID() {
        this(new OMVRBTreeRIDProvider(null, ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName("ORIDs")));
    }

    public OMVRBTreeRID(int binaryThreshold) {
        this(new OMVRBTreeRIDProvider(null, ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName("ORIDs"), binaryThreshold));
    }

    public OMVRBTreeRID(ODocument iRecord) {
        this(new OMVRBTreeRIDProvider(((OIdentifiable)iRecord.field("root")).getIdentity()));
        this.load();
    }

    public OMVRBTreeRID(String iClusterName) {
        this(new OMVRBTreeRIDProvider(iClusterName));
    }

    public OMVRBTreeRID(OMVRBTreeProvider<OIdentifiable, OIdentifiable> iProvider) {
        super(iProvider);
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
    }

    public OMVRBTreeRID(OMVRBTreeRID iSource) {
        super(new OMVRBTreeRIDProvider((OMVRBTreeRIDProvider)iSource.getProvider()));
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
        if (iSource.getProvider().isDirty() && ((OMVRBTreeRIDProvider)iSource.getProvider()).isEmbeddedStreaming()) {
            this.putAll(iSource.keySet());
        } else {
            this.load();
        }
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> setOwner(ORecord<?> owner) {
        super.setOwner(owner);
        return this;
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> load() {
        this.newEntries = null;
        super.load();
        if (this.root != null) {
            this.setSize(((OMVRBTreeRIDEntryProvider)((OMVRBTreeEntryPersistent)this.root).getProvider()).getTreeSize());
        } else {
            this.setSize(0);
        }
        return this;
    }

    @Override
    public OIdentifiable internalPut(OIdentifiable e, OIdentifiable v) {
        if (e == null) {
            return null;
        }
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (e.getIdentity().isNew()) {
            Object record = e.getRecord();
            if (record == null) {
                throw new OTransactionException("Cannot insert item in mvrb-tree because the transactional item was not found.");
            }
            if (this.newEntries == null) {
                this.newEntries = new IdentityHashMap();
            } else if (this.newEntries.containsKey(record)) {
                return record;
            }
            this.newEntries.put((ORecord<?>)record, NEWMAP_VALUE);
            this.setDirty();
            return null;
        }
        OIdentifiable oldValue = super.internalPut(e, null);
        if (!this.isMarshalling()) {
            if (oldValue != null) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.UPDATE, e, e, oldValue));
            } else {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, e, e));
            }
        }
        return oldValue;
    }

    public boolean isMarshalling() {
        return this.marshalling;
    }

    public void setMarshalling(boolean marshalling) {
        this.marshalling = marshalling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection<OIdentifiable> coll) {
        long timer = PROFILER.startChrono();
        try {
            for (OIdentifiable rid : coll) {
                this.internalPut(rid, null);
            }
            this.commitChanges();
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.putAll"), "Put multiple values in a MVRBTreeRID", timer);
        }
    }

    @Override
    public OIdentifiable remove(Object o) {
        OIdentifiable removed;
        if (this.hasNewItems() && this.newEntries.containsKey(o)) {
            removed = (OIdentifiable)o;
            this.newEntries.remove(o);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
            this.setDirty();
        } else if (this.containsKey(o)) {
            removed = (OIdentifiable)super.remove(o);
            this.setDirty();
        } else {
            removed = null;
        }
        if (removed != null) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, removed, null, removed));
        }
        return removed;
    }

    public boolean removeAll(Collection<?> c) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            Set<ORecord<?>> v = this.newEntries.keySet();
            v.removeAll(c);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
        }
        boolean modified = false;
        for (Object o : c) {
            if (this.remove(o) == null) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<?> c) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            Set<ORecord<?>> v = this.newEntries.keySet();
            v.retainAll(c);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
        }
        boolean modified = false;
        Iterator<OIdentifiable> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        if (this.newEntries != null) {
            this.newEntries.clear();
            this.newEntries = null;
        }
        this.setDirty();
        HashMap<OIdentifiable, OIdentifiable> origValues = this.changeListeners.isEmpty() ? null : new HashMap<OIdentifiable, OIdentifiable>(this);
        super.clear();
        if (origValues != null) {
            for (Map.Entry item : origValues.entrySet()) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent(OMultiValueChangeEvent.OChangeType.REMOVE, item.getKey(), null, item.getValue()));
            }
        } else {
            this.setDirty();
        }
    }

    @Override
    public boolean detach() {
        return this.saveAllNewEntries();
    }

    @Override
    public int size() {
        int tot = this.getTreeSize();
        if (this.newEntries != null) {
            tot += this.newEntries.size();
        }
        return tot;
    }

    @Override
    public int getTreeSize() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.getTreeSize();
    }

    @Override
    public boolean isEmpty() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        boolean empty = super.isEmpty();
        if (empty && this.newEntries != null) {
            empty = this.newEntries.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean containsKey(Object o) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        boolean found = super.containsKey(o);
        if (!found && this.hasNewItems()) {
            found = this.newEntries.containsKey(o);
        }
        return found;
    }

    public Iterator<OIdentifiable> iterator() {
        return this.iterator(this.autoConvertToRecord);
    }

    public OLazyIterator<OIdentifiable> iterator(boolean iAutoConvertToRecord) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            if (super.size() == 0) {
                return new OLazyRecordIterator(new HashSet(this.newEntries.keySet()), iAutoConvertToRecord);
            }
            return new OLazyRecordMultiIterator(null, new Object[]{this.keySet(), new HashSet(this.newEntries.keySet())}, iAutoConvertToRecord);
        }
        return new OLazyRecordIterator(this.keySet().iterator(), iAutoConvertToRecord);
    }

    @Override
    public Set<OIdentifiable> keySet() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.keySet();
    }

    @Override
    public Collection<OIdentifiable> values() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.values();
    }

    public Object[] toArray() {
        Object[] result = this.keySet().toArray();
        if (this.newEntries != null && !this.newEntries.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newEntries.size());
            for (ORecord<?> r : this.newEntries.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        T[] result = this.keySet().toArray(a);
        if (this.newEntries != null && !this.newEntries.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newEntries.size());
            for (ORecord<?> r : this.newEntries.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    @Override
    protected void saveTreeNode() {
    }

    @Override
    public int commitChanges() {
        if (!((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
            this.saveAllNewEntries();
            return super.commitChanges();
        }
        return 0;
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> save() {
        return this;
    }

    @Override
    protected void setSizeDelta(int iDelta) {
        this.setSize(this.getTreeSize() + iDelta);
    }

    public void setDirtyOwner() {
        if (this.getOwner() != null) {
            this.getOwner().setDirty();
        }
    }

    public void onAfterTxCommit() {
        Set<ORID> nodesInMemory = this.getAllNodesInCache();
        if (nodesInMemory.isEmpty()) {
            return;
        }
        HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
        for (ORID rid : keys) {
            if (!rid.getClusterPosition().isTemporary()) continue;
            OMVRBTreeEntryPersistent entry = this.searchNodeInCache(rid);
            this.removeNodeFromCache(rid);
            this.addNodeInCache(entry);
        }
    }

    public boolean saveAllNewEntries() {
        if (this.hasNewItems()) {
            HashSet temp = new HashSet(this.newEntries.keySet());
            for (ORecord oRecord : temp) {
                if (oRecord.getIdentity().isNew()) {
                    oRecord.save();
                }
                if (oRecord.getIdentity().isNew()) continue;
                if (this.newEntries != null) {
                    this.newEntries.remove(oRecord);
                    if (this.newEntries.size() == 0) {
                        this.newEntries = null;
                    }
                }
                this.internalPut(oRecord.getIdentity(), null);
            }
            if (!((OMVRBTreeRIDProvider)this.dataProvider).isEmbeddedStreaming()) {
                super.commitChanges();
            }
            if (this.newEntries != null) {
                return false;
            }
        }
        return true;
    }

    public boolean hasNewItems() {
        return this.newEntries != null && !this.newEntries.isEmpty();
    }

    @Override
    public String toString() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        StringBuilder buffer = new StringBuilder(super.toString());
        if (this.hasNewItems()) {
            buffer.append("{new items (");
            buffer.append(this.newEntries.size());
            buffer.append("): ");
            boolean first = true;
            for (ORecord<?> item : this.newEntries.keySet()) {
                if (!first) {
                    buffer.append(", ");
                    first = false;
                }
                if (item == null) continue;
                buffer.append(item.toString());
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    @Override
    protected void setRoot(OMVRBTreeEntry<OIdentifiable, OIdentifiable> iRoot) {
        int size = 0;
        if (iRoot != null) {
            size = this.getTreeSize();
        }
        super.setRoot(iRoot);
        if (iRoot != null) {
            this.setSize(size);
        }
    }

    protected <RET> RET setDirty() {
        ((OMVRBTreeRIDProvider)this.getProvider()).setDirty();
        if (((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
            this.setDirtyOwner();
        } else if (ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            this.save();
        }
        return (RET)this;
    }

    public IdentityHashMap<ORecord<?>, Object> getTemporaryEntries() {
        return this.newEntries;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        this.setDirty();
        for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> changeEvents) {
        HashMap<OIdentifiable, OIdentifiable> reverted = new HashMap<OIdentifiable, OIdentifiable>(this);
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = changeEvents.listIterator(changeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public Class<?> getGenericClass() {
        return null;
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return this.iterator(false);
    }

    @Override
    public void convertLinks2Records() {
    }

    @Override
    public boolean convertRecords2Links() {
        return false;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }
}

