/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.RouterStub;
import org.jgroups.stack.RouterStubManager;
import org.jgroups.util.Responses;
import org.jgroups.util.UUID;

public class TCPGOSSIP
extends Discovery {
    @Property(description="Max time for socket creation. Default is 1000 msec")
    int sock_conn_timeout = 1000;
    @Property(description="Max time in milliseconds to block on a read. 0 blocks forever")
    int sock_read_timeout = 3000;
    @Property(description="Interval (ms) by which a disconnected stub attempts to reconnect to the GossipRouter")
    long reconnect_interval = 10000L;
    private final List<InetSocketAddress> initial_hosts = new CopyOnWriteArrayList<InetSocketAddress>();
    protected volatile RouterStubManager stubManager;

    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts2.class)
    public void setInitialHosts(List<InetSocketAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        this.initial_hosts.addAll(hosts);
    }

    public List<InetSocketAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public RouterStubManager getStubManager() {
        return this.stubManager;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this);
        TP transport = this.getTransport();
        if (transport instanceof TUNNEL) {
            throw new IllegalStateException("TCPGOSSIP cannot be used with TUNNEL; use either TUNNEL:PING or TCP:TCPGOSSIP as valid configurations");
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.stubManager.disconnectStubs();
    }

    @Override
    public void destroy() {
        this.stubManager.destroyStubs();
        super.destroy();
    }

    @Override
    public void handleConnect() {
        if (this.cluster_name == null || this.local_addr == null) {
            this.log.error("group_addr or local_addr is null, cannot register with GossipRouter(s)");
        } else {
            this.log.trace("registering " + this.local_addr + " under " + this.cluster_name + " with GossipRouter");
            this.stubManager.destroyStubs();
            this.stubManager = new RouterStubManager(this, this.cluster_name, this.local_addr, this.reconnect_interval);
            for (InetSocketAddress host : this.initial_hosts) {
                this.stubManager.createAndRegisterStub(host.getHostName(), host.getPort(), null);
            }
            this.connectAllStubs(this.cluster_name, this.local_addr);
        }
    }

    @Override
    public void handleDisconnect() {
        this.stubManager.disconnectStubs();
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        if (this.cluster_name == null) {
            this.log.error("cluster_name is null, cannot get membership");
            return;
        }
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, false, UUID.get(this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        HashSet<PhysicalAddress> physical_addrs = new HashSet<PhysicalAddress>();
        this.log.trace("fetching members from GossipRouter(s)");
        for (RouterStub stub : this.stubManager.getStubs()) {
            try {
                stub.getMembers(this.cluster_name, responses);
                for (PingData ping_data : responses) {
                    if (ping_data == null || ping_data.getPhysicalAddr() == null) continue;
                    physical_addrs.add(ping_data.getPhysicalAddr());
                }
            }
            catch (Throwable t) {
                this.log.warn("failed fetching members from " + stub.getGossipRouterAddress() + ": " + t + ", cause: " + t.getCause());
            }
        }
        for (PhysicalAddress addr : physical_addrs) {
            if (physical_addr != null && addr.equals(physical_addr)) continue;
            Message msg = new Message(addr).setFlag(Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB).putHeader(this.id, hdr).setBuffer(TCPGOSSIP.marshal(data));
            this.log.trace("%s: sending discovery request to %s", this.local_addr, msg.getDest());
            this.down_prot.down(new Event(1, msg));
        }
    }

    @ManagedOperation
    public void addInitialHost(String hostname, int port) {
        this.removeInitialHost(hostname, port);
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        this.initial_hosts.add(isa);
        RouterStub s = new RouterStub(isa.getHostName(), isa.getPort(), null, this.stubManager);
        this.connect(s, this.cluster_name, this.local_addr);
        this.stubManager.registerStub(s);
    }

    @ManagedOperation
    public boolean removeInitialHost(String hostname, int port) {
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        RouterStub stub = new RouterStub(isa);
        RouterStub unregisterStub = this.stubManager.unregisterStub(stub);
        if (unregisterStub != null) {
            this.stubManager.stopReconnecting(unregisterStub);
            unregisterStub.destroy();
        }
        return this.initial_hosts.remove(isa);
    }

    protected void connectAllStubs(String group, Address logical_addr) {
        String logical_name = UUID.get(logical_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        for (RouterStub stub : this.stubManager.getStubs()) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("trying to connect to " + stub.getGossipRouterAddress());
                }
                stub.connect(group, logical_addr, logical_name, physical_addr);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed connecting to " + stub.getGossipRouterAddress() + ": " + e);
                }
                this.stubManager.startReconnecting(stub);
            }
        }
    }

    protected void connect(RouterStub stub, String group, Address logical_addr) {
        String logical_name = UUID.get(logical_addr);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("trying to connect to " + stub.getGossipRouterAddress());
            }
            stub.connect(group, logical_addr, logical_name, physical_addr);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("failed connecting to " + stub.getGossipRouterAddress() + ": " + e);
            }
            this.stubManager.startReconnecting(stub);
        }
    }
}

