/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.lang.reflect.Method;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MethodTarget {
    private final Method method;
    private final Object target;
    private final String remainingBuffer;
    private final String key;

    public MethodTarget(Method method, Object target) {
        this(method, target, null, null);
    }

    public MethodTarget(Method method, Object target, String remainingBuffer, String key) {
        Assert.notNull((Object)method, (String)"Method is required");
        Assert.notNull((Object)target, (String)"Target is required");
        this.key = StringUtils.trimWhitespace((String)key);
        this.method = method;
        this.remainingBuffer = StringUtils.trimWhitespace((String)remainingBuffer);
        this.target = target;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MethodTarget)) {
            return false;
        }
        MethodTarget otherMethodTarget = (MethodTarget)other;
        return this.method.equals(otherMethodTarget.getMethod()) && this.target.equals(otherMethodTarget.getTarget());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.method) + ObjectUtils.nullSafeHashCode((Object)this.target);
    }

    public final String toString() {
        ToStringCreator tsc = new ToStringCreator((Object)this);
        tsc.append("target", this.target);
        tsc.append("method", (Object)this.method);
        tsc.append("remainingBuffer", (Object)this.remainingBuffer);
        tsc.append("key", (Object)this.key);
        return tsc.toString();
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRemainingBuffer() {
        return this.remainingBuffer;
    }

    public Object getTarget() {
        return this.target;
    }
}

