/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.springframework.shell.core.AbstractShell;
import org.springframework.shell.core.CliOptionContext;
import org.springframework.shell.core.CliSimpleParserContext;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.ParserUtils;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.ExceptionUtils;
import org.springframework.shell.support.util.NaturalOrderComparator;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleParser
implements Parser {
    private static final Logger LOGGER = HandlerUtils.getLogger(SimpleParser.class);
    private static final Comparator<Object> COMPARATOR = new NaturalOrderComparator<Object>();
    private final Object mutex = new Object();
    private final Set<Converter<?>> converters = new HashSet();
    private final Set<CommandMarker> commands = new HashSet<CommandMarker>();
    private final Map<String, MethodTarget> availabilityIndicators = new HashMap<String, MethodTarget>();

    private MethodTarget getAvailabilityIndicator(String command) {
        return this.availabilityIndicators.get(command);
    }

    private List<List<String>> getMandatoryOptionsKeys(Collection<CliOption> cliOptions) {
        return this.getOptionsKeys(cliOptions, false);
    }

    private List<List<String>> getOptionsKeys(Collection<CliOption> cliOptions, boolean includeOptionalOptions) {
        ArrayList<List<String>> optionsKeys = new ArrayList<List<String>>();
        for (CliOption option : cliOptions) {
            ArrayList<String> keys;
            if (includeOptionalOptions) {
                keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(option.key()));
                optionsKeys.add(keys);
                continue;
            }
            if (!option.mandatory()) continue;
            keys = new ArrayList();
            keys.addAll(Arrays.asList(option.key()));
            optionsKeys.add(keys);
        }
        return optionsKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParseResult parse(String rawInput) {
        Object object = this.mutex;
        synchronized (object) {
            Assert.notNull((Object)rawInput, (String)"Raw input required");
            String input = this.normalise(rawInput);
            Collection<MethodTarget> matchingTargets = this.locateTargets(input, true, true);
            if (matchingTargets.isEmpty()) {
                matchingTargets.addAll(this.locateTargets(input, true, false));
                if (matchingTargets.isEmpty()) {
                    this.commandNotFound(LOGGER, input);
                } else {
                    LOGGER.warning("Command '" + input + "' was found but is not currently available (type 'help' then ENTER to learn about this command)");
                }
                return null;
            }
            if (matchingTargets.size() > 1) {
                LOGGER.warning("Ambigious command '" + input + "' (for assistance press " + AbstractShell.completionKeys + " or type \"hint\" then hit ENTER)");
                return null;
            }
            MethodTarget methodTarget = matchingTargets.iterator().next();
            Annotation[][] parameterAnnotations = methodTarget.getMethod().getParameterAnnotations();
            if (parameterAnnotations.length == 0) {
                return new ParseResult(methodTarget.getMethod(), methodTarget.getTarget(), null);
            }
            ArrayList<SimpleParser> arguments = new ArrayList<SimpleParser>(methodTarget.getMethod().getParameterTypes().length);
            Map<String, String> options = null;
            try {
                options = ParserUtils.tokenize(methodTarget.getRemainingBuffer());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning(ExceptionUtils.extractRootCause(e).getMessage());
                return null;
            }
            Set<CliOption> cliOptions = this.getCliOptions(parameterAnnotations);
            Iterator<CliOption> i$ = cliOptions.iterator();
            while (true) {
                int len$;
                String[] arr$;
                String sourcedFrom;
                String value;
                Class<?> requiredType;
                CliOption cliOption;
                if (i$.hasNext()) {
                    cliOption = i$.next();
                    requiredType = methodTarget.getMethod().getParameterTypes()[arguments.size()];
                    if (cliOption.systemProvided()) {
                        if (!SimpleParser.class.isAssignableFrom(requiredType)) {
                            LOGGER.warning("Parameter type '" + requiredType + "' is not system provided");
                            return null;
                        }
                        SimpleParser result = this;
                        arguments.add(result);
                        continue;
                    }
                    value = null;
                    sourcedFrom = null;
                    arr$ = cliOption.key();
                    len$ = arr$.length;
                } else {
                    Set<String> unavailableOptions = this.getSpecifiedUnavailableOptions(cliOptions, options);
                    if (unavailableOptions.isEmpty()) {
                        return new ParseResult(methodTarget.getMethod(), methodTarget.getTarget(), arguments.toArray());
                    }
                    StringBuilder message = new StringBuilder();
                    if (unavailableOptions.size() == 1) {
                        message.append("Option '").append(unavailableOptions.iterator().next()).append("' is not available for this command. ");
                    } else {
                        message.append("Options ").append(StringUtils.collectionToDelimitedString(unavailableOptions, (String)", ", (String)"'", (String)"'")).append(" are not available for this command. ");
                    }
                    message.append("Use tab assist or the \"help\" command to see the legal options");
                    LOGGER.warning(message.toString());
                    return null;
                }
                for (int i$2 = 0; i$2 < len$; ++i$2) {
                    String possibleKey = arr$[i$2];
                    if (!options.containsKey(possibleKey)) continue;
                    if (sourcedFrom != null) {
                        LOGGER.warning("You cannot specify option '" + possibleKey + "' when you have also specified '" + sourcedFrom + "' in the same command");
                        return null;
                    }
                    sourcedFrom = possibleKey;
                    value = options.get(possibleKey);
                }
                boolean mandatory = !StringUtils.hasText(value) && cliOption.mandatory();
                boolean specifiedKey = !StringUtils.hasText(value) && options.containsKey(sourcedFrom);
                boolean specifiedKeyWithoutValue = false;
                if (specifiedKey && "__NULL__".equals(value = cliOption.specifiedDefaultValue())) {
                    specifiedKeyWithoutValue = true;
                }
                if (mandatory || specifiedKeyWithoutValue) {
                    if ("".equals(cliOption.key()[0])) {
                        StringBuilder message = new StringBuilder("You should specify a default option ");
                        if (cliOption.key().length > 1) {
                            message.append("(otherwise known as option '").append(cliOption.key()[1]).append("') ");
                        }
                        message.append("for this command");
                        LOGGER.warning(message.toString());
                    } else {
                        this.printHintMessage(cliOptions, options);
                    }
                    return null;
                }
                if ("".equals(value)) {
                    value = cliOption.specifiedDefaultValue();
                }
                if (value == null) {
                    value = cliOption.unspecifiedDefaultValue();
                }
                if ("__NULL__".equals(value)) {
                    if (requiredType.isPrimitive()) {
                        LOGGER.warning("Nulls cannot be presented to primitive type " + requiredType.getSimpleName() + " for option '" + StringUtils.arrayToCommaDelimitedString((Object[])cliOption.key()) + "'");
                        return null;
                    }
                    arguments.add(null);
                    continue;
                }
                try {
                    CliOptionContext.setOptionContext(cliOption.optionContext());
                    CliSimpleParserContext.setSimpleParserContext(this);
                    Converter<?> c = null;
                    for (Converter<?> candidate : this.converters) {
                        if (!candidate.supports(requiredType, cliOption.optionContext())) continue;
                        c = candidate;
                        break;
                    }
                    if (c == null) {
                        throw new IllegalStateException("TODO: Add basic type conversion");
                    }
                    Object result = c.convertFromText(value, requiredType, cliOption.optionContext());
                    if (result == null && cliOption.mandatory()) {
                        throw new IllegalStateException();
                    }
                    arguments.add((SimpleParser)result);
                    continue;
                }
                catch (RuntimeException e) {
                    LOGGER.warning(e.getClass().getName() + ": Failed to convert '" + value + "' to type " + requiredType.getSimpleName() + " for option '" + StringUtils.arrayToCommaDelimitedString((Object[])cliOption.key()) + "'");
                    if (StringUtils.hasText((String)e.getMessage())) {
                        LOGGER.warning(e.getMessage());
                    }
                    ParseResult parseResult = null;
                    return parseResult;
                }
                finally {
                    CliOptionContext.resetOptionContext();
                    CliSimpleParserContext.resetSimpleParserContext();
                    continue;
                }
                break;
            }
        }
    }

    private void printHintMessage(Set<CliOption> cliOptions, Map<String, String> options) {
        boolean hintForOptions = true;
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append("You should specify option (");
        StringBuilder valueBuilder = new StringBuilder();
        valueBuilder.append("You should specify value for option '");
        List<List<String>> optionsKeys = this.getOptionsKeys(cliOptions, true);
        for (List<String> keys : optionsKeys) {
            boolean found = false;
            for (String key : keys) {
                if (!options.containsKey(key)) continue;
                if (!StringUtils.hasText((String)options.get(key))) {
                    valueBuilder.append(key);
                    valueBuilder.append("' for this command");
                    hintForOptions = false;
                }
                found = true;
                break;
            }
            if (found) continue;
            optionBuilder.append("--");
            optionBuilder.append(keys.get(0));
            optionBuilder.append(", ");
        }
        String hintForOption = optionBuilder.toString();
        hintForOption = hintForOption.substring(0, hintForOption.length() - 2);
        if (hintForOptions) {
            LOGGER.warning(hintForOption + ") for this command");
        } else {
            LOGGER.warning(valueBuilder.toString());
        }
    }

    String normalise(String rawInput) {
        return rawInput.replaceAll(" +", " ").trim();
    }

    private Set<String> getSpecifiedUnavailableOptions(Set<CliOption> cliOptions, Map<String, String> options) {
        LinkedHashSet<String> cliOptionKeySet = new LinkedHashSet<String>();
        for (CliOption cliOption : cliOptions) {
            for (String key : cliOption.key()) {
                cliOptionKeySet.add(key.toLowerCase());
            }
        }
        LinkedHashSet<String> unavailableOptions = new LinkedHashSet<String>();
        for (String suppliedOption : options.keySet()) {
            if (cliOptionKeySet.contains(suppliedOption.toLowerCase())) continue;
            unavailableOptions.add(suppliedOption);
        }
        return unavailableOptions;
    }

    private Set<CliOption> getCliOptions(Annotation[][] parameterAnnotations) {
        LinkedHashSet<CliOption> cliOptions = new LinkedHashSet<CliOption>();
        Annotation[][] arr$ = parameterAnnotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                if (!(annotation instanceof CliOption)) continue;
                CliOption cliOption = (CliOption)annotation;
                cliOptions.add(cliOption);
            }
        }
        return cliOptions;
    }

    protected void commandNotFound(Logger logger, String buffer) {
        logger.warning("Command '" + buffer + "' not found (for assistance press " + AbstractShell.completionKeys + ")");
    }

    private Collection<MethodTarget> locateTargets(String buffer, boolean strictMatching, boolean checkAvailabilityIndicators) {
        Assert.notNull((Object)buffer, (String)"Buffer required");
        HashSet<MethodTarget> result = new HashSet<MethodTarget>();
        for (CommandMarker command : this.commands) {
            for (Method method : command.getClass().getMethods()) {
                CliCommand cmd = method.getAnnotation(CliCommand.class);
                if (cmd == null) continue;
                if (checkAvailabilityIndicators) {
                    Boolean available = null;
                    for (String value : cmd.value()) {
                        MethodTarget mt = this.getAvailabilityIndicator(value);
                        if (mt == null) continue;
                        Assert.isNull((Object)available, (String)("More than one availability indicator is defined for '" + method.toGenericString() + "'"));
                        try {
                            available = (Boolean)mt.getMethod().invoke(mt.getTarget(), new Object[0]);
                        }
                        catch (Exception e) {
                            available = false;
                        }
                    }
                    if (available != null && !available.booleanValue()) continue;
                }
                for (String value : cmd.value()) {
                    String remainingBuffer = SimpleParser.isMatch(buffer, value, strictMatching);
                    if (remainingBuffer == null) continue;
                    result.add(new MethodTarget(method, command, remainingBuffer, value));
                }
            }
        }
        return result;
    }

    static String isMatch(String buffer, String command, boolean strictMatching) {
        if ("".equals(buffer.trim())) {
            return "";
        }
        Object[] commandWords = StringUtils.delimitedListToStringArray((String)command, (String)" ");
        int lastCommandWordUsed = 0;
        Assert.notEmpty((Object[])commandWords, (String)"Command required");
        String bufferToReturn = null;
        String lastWord = null;
        block0: for (int bufferIndex = 0; bufferIndex < buffer.length(); ++bufferIndex) {
            String bufferSoFarIncludingThis = buffer.substring(0, bufferIndex + 1);
            String bufferRemaining = buffer.substring(bufferIndex + 1);
            int bufferLastIndexOfWord = bufferSoFarIncludingThis.lastIndexOf(" ");
            String wordSoFarIncludingThis = bufferSoFarIncludingThis;
            if (bufferLastIndexOfWord != -1) {
                wordSoFarIncludingThis = bufferSoFarIncludingThis.substring(bufferLastIndexOfWord);
            }
            if (wordSoFarIncludingThis.equals(" ") || bufferIndex == buffer.length() - 1) {
                if (bufferIndex == buffer.length() - 1 && !"".equals(wordSoFarIncludingThis.trim())) {
                    lastWord = wordSoFarIncludingThis.trim();
                }
                for (int candidate = lastCommandWordUsed; candidate < commandWords.length; ++candidate) {
                    if (lastWord == null || lastWord.length() <= 0 || !((String)commandWords[candidate]).startsWith(lastWord)) continue;
                    if (bufferToReturn == null && lastCommandWordUsed == 0 && candidate > 0) break block0;
                    if (bufferToReturn != null && candidate != lastCommandWordUsed + 1) {
                        bufferToReturn = null;
                        break block0;
                    }
                    bufferToReturn = bufferRemaining;
                    lastCommandWordUsed = candidate;
                    if (candidate + 1 != commandWords.length) continue block0;
                    break block0;
                }
                bufferToReturn = null;
                break;
            }
            lastWord = wordSoFarIncludingThis.trim();
        }
        if (!(bufferToReturn == null || strictMatching && lastCommandWordUsed + 1 != commandWords.length)) {
            return bufferToReturn;
        }
        return null;
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        int result = this.completeAdvanced(buffer, cursor, completions);
        for (Completion completion : completions) {
            candidates.add(completion.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public int completeAdvanced(String buffer, int cursor, List<Completion> candidates) {
        Object object = this.mutex;
        synchronized (object) {
            void var16_35;
            Map<String, String> options;
            Assert.notNull((Object)buffer, (String)"Buffer required");
            Assert.notNull(candidates, (String)"Candidates list required");
            while (buffer.startsWith(" ")) {
                buffer = buffer.replaceFirst("^ ", "");
                --cursor;
            }
            while (buffer.contains("  ")) {
                buffer = buffer.replaceFirst("  ", " ");
                --cursor;
            }
            String translated = buffer.substring(0, cursor);
            Collection<MethodTarget> targets = this.locateTargets(translated, false, true);
            TreeSet<Object> results = new TreeSet<Object>(COMPARATOR);
            if (targets.isEmpty()) {
                return cursor;
            }
            if (targets.size() > 1) {
                for (MethodTarget target : targets) {
                    int startAt = translated.length();
                    int stopAt = target.getKey().indexOf(" ", startAt);
                    if (stopAt == -1) {
                        stopAt = target.getKey().length();
                    }
                    results.add(new Completion(target.getKey().substring(0, stopAt) + " "));
                }
                candidates.addAll(results);
                return 0;
            }
            MethodTarget methodTarget = targets.iterator().next();
            CliCommand cmd = methodTarget.getMethod().getAnnotation(CliCommand.class);
            Assert.notNull((Object)cmd, (String)("CliCommand unavailable for '" + methodTarget.getMethod().toGenericString() + "'"));
            try {
                options = ParserUtils.tokenize(methodTarget.getRemainingBuffer());
            }
            catch (IllegalArgumentException ex) {
                candidates.add(new Completion(translated + "\""));
                return 0;
            }
            Annotation[][] parameterAnnotations = methodTarget.getMethod().getParameterAnnotations();
            if (parameterAnnotations.length == 0) {
                for (String value : cmd.value()) {
                    if (!buffer.startsWith(value) && !value.startsWith(buffer)) continue;
                    results.add(new Completion(value));
                }
                candidates.addAll(results);
                return 0;
            }
            if (options.isEmpty()) {
                for (String value : cmd.value()) {
                    if (!value.startsWith(buffer) || buffer.startsWith(value)) continue;
                    results.add(new Completion(value + " "));
                }
                if (results.size() > 0) {
                    candidates.addAll(results);
                    return 0;
                }
            }
            ArrayList<CliOption> cliOptions = new ArrayList<CliOption>();
            for (Object[] objectArray : parameterAnnotations) {
                CliOption cliOption = null;
                for (Annotation annotation : objectArray) {
                    if (!(annotation instanceof CliOption)) continue;
                    cliOption = (CliOption)annotation;
                }
                Assert.notNull((Object)cliOption, (String)("CliOption not found for parameter '" + Arrays.toString(objectArray) + "'"));
                cliOptions.add(cliOption);
            }
            ArrayList<CliOption> alreadySpecified = new ArrayList<CliOption>();
            for (CliOption option : cliOptions) {
                for (String value : option.key()) {
                    if (!options.containsKey(value)) continue;
                    alreadySpecified.add(option);
                    break;
                }
                if (!option.systemProvided()) continue;
                alreadySpecified.add(option);
            }
            ArrayList<CliOption> unspecified = new ArrayList<CliOption>(cliOptions);
            unspecified.removeAll(alreadySpecified);
            String lastOptionKey = null;
            Object var16_33 = null;
            if (options.size() > 0) {
                lastOptionKey = new ArrayList<String>(options.keySet()).get(options.keySet().size() - 1);
                String string = options.get(lastOptionKey);
            }
            if (methodTarget.getRemainingBuffer().endsWith("--")) {
                boolean showAllRemaining = true;
                for (CliOption include : unspecified) {
                    if (!include.mandatory()) continue;
                    showAllRemaining = false;
                    break;
                }
                for (CliOption include : unspecified) {
                    for (String value : include.key()) {
                        if ("".equals(value)) continue;
                        results.add(new Completion(translated + value + " "));
                    }
                    if (showAllRemaining) continue;
                    break;
                }
                candidates.addAll(results);
                return 0;
            }
            if (lastOptionKey == null || !"".equals(lastOptionKey) && !"".equals(var16_35) && translated.endsWith(" ")) {
                for (CliOption include : unspecified) {
                    for (String value : include.key()) {
                        if (!include.mandatory() && "*".equals(include.unspecifiedDefaultValue()) && !"".equals(value)) {
                            try {
                                for (Converter<?> candidate : this.converters) {
                                    Class<?> paramType = null;
                                    int index = -1;
                                    block22: for (Annotation[] a : methodTarget.getMethod().getParameterAnnotations()) {
                                        ++index;
                                        for (Annotation an : a) {
                                            if (!(an instanceof CliOption) || !((Object)an).equals(include)) continue;
                                            paramType = methodTarget.getMethod().getParameterTypes()[index];
                                            continue block22;
                                        }
                                    }
                                    if (paramType == null || !candidate.supports(paramType, include.optionContext())) continue;
                                    candidate.convertFromText("*", paramType, include.optionContext());
                                    break;
                                }
                            }
                            catch (RuntimeException notYetReady) {
                                if (translated.endsWith(" ")) {
                                    results.add(new Completion(translated + "--" + value + " "));
                                    continue;
                                }
                                results.add(new Completion(translated + " --" + value + " "));
                                continue;
                            }
                        }
                        if ("".equals(value) || !include.mandatory()) continue;
                        this.handleMandatoryCompletion(translated, unspecified, value, results);
                    }
                }
                if (results.size() > 0) {
                    candidates.addAll(results);
                    return 0;
                }
            }
            if ((var16_35 == null || "".equals(var16_35)) && !translated.endsWith(" ")) {
                for (CliOption option : cliOptions) {
                    for (String value : option.key()) {
                        if (value == null || lastOptionKey == null || !value.regionMatches(true, 0, lastOptionKey, 0, lastOptionKey.length())) continue;
                        String completionValue = translated.substring(0, translated.length() - lastOptionKey.length()) + value + " ";
                        results.add(new Completion(completionValue));
                    }
                }
                candidates.addAll(results);
                return 0;
            }
            if (lastOptionKey != null && !"".equals(lastOptionKey)) {
                Class<?>[] parameterTypes = methodTarget.getMethod().getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    CliOption option = (CliOption)cliOptions.get(i);
                    Class<?> parameterType = parameterTypes[i];
                    for (String key : option.key()) {
                        String suggestion;
                        if (!key.equals(lastOptionKey)) continue;
                        ArrayList<Completion> allValues = new ArrayList<Completion>();
                        String suffix = " ";
                        for (Converter<?> candidate : this.converters) {
                            if (!candidate.supports(parameterType, option.optionContext())) continue;
                            boolean addSpace = candidate.getAllPossibleValues(allValues, parameterType, (String)var16_35, option.optionContext(), methodTarget);
                            if (addSpace) break;
                            suffix = "";
                            break;
                        }
                        if (allValues.isEmpty()) {
                            if (Boolean.class.isAssignableFrom(parameterType) || Boolean.TYPE.isAssignableFrom(parameterType)) {
                                allValues.add(new Completion("true"));
                                allValues.add(new Completion("false"));
                            }
                            if (Number.class.isAssignableFrom(parameterType)) {
                                allValues.add(new Completion("0"));
                                allValues.add(new Completion("1"));
                                allValues.add(new Completion("2"));
                                allValues.add(new Completion("3"));
                                allValues.add(new Completion("4"));
                                allValues.add(new Completion("5"));
                                allValues.add(new Completion("6"));
                                allValues.add(new Completion("7"));
                                allValues.add(new Completion("8"));
                                allValues.add(new Completion("9"));
                            }
                        }
                        String prefix = "";
                        if (!translated.endsWith(" ")) {
                            prefix = " ";
                        }
                        for (Completion currentValue : allValues) {
                            if (!StringUtils.hasText((String)var16_35)) {
                                results.add(new Completion(prefix + currentValue.getValue() + suffix, currentValue.getFormattedValue(), currentValue.getHeading(), currentValue.getOrder()));
                                continue;
                            }
                            if (!currentValue.getValue().toLowerCase().startsWith(var16_35.toLowerCase()) || var16_35.equalsIgnoreCase(currentValue.getValue()) || var16_35.length() >= currentValue.getValue().length()) continue;
                            results.add(new Completion(prefix + currentValue.getValue() + suffix, currentValue.getFormattedValue(), currentValue.getHeading(), currentValue.getOrder()));
                        }
                        StringBuilder help = new StringBuilder();
                        help.append(OsUtils.LINE_SEPARATOR);
                        help.append(option.mandatory() ? "required --" : "optional --");
                        if ("".equals(option.help())) {
                            help.append(lastOptionKey).append(": ").append("No help available");
                        } else {
                            help.append(lastOptionKey).append(": ").append(option.help());
                        }
                        if (option.specifiedDefaultValue().equals(option.unspecifiedDefaultValue())) {
                            if (option.specifiedDefaultValue().equals("__NULL__")) {
                                help.append("; no default value");
                            } else {
                                help.append("; default: '").append(option.specifiedDefaultValue()).append("'");
                            }
                        } else {
                            if (!"".equals(option.specifiedDefaultValue()) && !"__NULL__".equals(option.specifiedDefaultValue())) {
                                help.append("; default if option present: '").append(option.specifiedDefaultValue()).append("'");
                            }
                            if (!"".equals(option.unspecifiedDefaultValue()) && !"__NULL__".equals(option.unspecifiedDefaultValue())) {
                                help.append("; default if option not present: '").append(option.unspecifiedDefaultValue()).append("'");
                            }
                        }
                        LOGGER.info(help.toString());
                        if (results.size() == 1 && (suggestion = ((Completion)results.iterator().next()).getValue().trim()).equals(var16_35)) {
                            return 0;
                        }
                        if (results.size() > 0) {
                            candidates.addAll(results);
                            if (translated.endsWith(" ")) {
                                return translated.lastIndexOf(" ") + 1;
                            }
                            return translated.trim().lastIndexOf(" ");
                        }
                        return 0;
                    }
                }
            }
            return 0;
        }
    }

    private void handleMandatoryCompletion(String translated, List<CliOption> unspecified, String value, SortedSet<Completion> results) {
        StringBuilder strBuilder = new StringBuilder(translated);
        if (!translated.endsWith(" ")) {
            strBuilder.append(" ");
        }
        strBuilder.append("--");
        strBuilder.append(value);
        strBuilder.append(" ");
        results.add(new Completion(strBuilder.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainHelp(@CliOption(key={"", "command"}, optionContext="availableCommands", help="Command name to provide help for") String buffer) {
        Object object = this.mutex;
        synchronized (object) {
            MethodTarget methodTarget;
            Annotation[][] parameterAnnotations;
            if (buffer == null) {
                buffer = "";
            }
            StringBuilder sb = new StringBuilder();
            Collection<MethodTarget> matchingTargets = this.locateTargets(buffer, false, false);
            if (matchingTargets.size() == 1 && (parameterAnnotations = (methodTarget = matchingTargets.iterator().next()).getMethod().getParameterAnnotations()).length > 0) {
                CliCommand cliCommand = methodTarget.getMethod().getAnnotation(CliCommand.class);
                Assert.notNull((Object)cliCommand, (String)"CliCommand not found");
                for (String string : cliCommand.value()) {
                    sb.append("Keyword:                   ").append(string).append(OsUtils.LINE_SEPARATOR);
                }
                sb.append("Description:               ").append(cliCommand.help()).append(OsUtils.LINE_SEPARATOR);
                for (String string : parameterAnnotations) {
                    CliOption cliOption = null;
                    for (String a : string) {
                        if (!(a instanceof CliOption)) continue;
                        cliOption = (CliOption)((Object)a);
                        for (String key : cliOption.key()) {
                            if ("".equals(key)) {
                                key = "** default **";
                            }
                            sb.append(" Keyword:                  ").append(key).append(OsUtils.LINE_SEPARATOR);
                        }
                        sb.append("   Help:                   ").append(cliOption.help()).append(OsUtils.LINE_SEPARATOR);
                        sb.append("   Mandatory:              ").append(cliOption.mandatory()).append(OsUtils.LINE_SEPARATOR);
                        sb.append("   Default if specified:   '").append(cliOption.specifiedDefaultValue()).append("'").append(OsUtils.LINE_SEPARATOR);
                        sb.append("   Default if unspecified: '").append(cliOption.unspecifiedDefaultValue()).append("'").append(OsUtils.LINE_SEPARATOR);
                        sb.append(OsUtils.LINE_SEPARATOR);
                    }
                    Assert.notNull((Object)cliOption, (String)("CliOption not found for parameter '" + Arrays.toString((Object[])string) + "'"));
                }
            }
            TreeSet<Object> result = new TreeSet<Object>(COMPARATOR);
            for (MethodTarget methodTarget2 : matchingTargets) {
                CliCommand cmd = methodTarget2.getMethod().getAnnotation(CliCommand.class);
                if (cmd == null) continue;
                for (String value : cmd.value()) {
                    if ("".equals(cmd.help())) {
                        result.add("* " + value);
                        continue;
                    }
                    result.add("* " + value + " - " + cmd.help());
                }
            }
            for (String string : result) {
                sb.append(string).append(OsUtils.LINE_SEPARATOR);
            }
            LOGGER.info(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEveryCommand() {
        Object object = this.mutex;
        synchronized (object) {
            TreeSet<Object> result = new TreeSet<Object>(COMPARATOR);
            for (CommandMarker o : this.commands) {
                Method[] methods;
                for (Method m : methods = o.getClass().getMethods()) {
                    CliCommand cmd = m.getAnnotation(CliCommand.class);
                    if (cmd == null) continue;
                    result.addAll(Arrays.asList(cmd.value()));
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(CommandMarker command) {
        Object object = this.mutex;
        synchronized (object) {
            this.commands.add(command);
            for (Method method : command.getClass().getMethods()) {
                CliAvailabilityIndicator availability = method.getAnnotation(CliAvailabilityIndicator.class);
                if (availability == null) continue;
                Assert.isTrue((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)("CliAvailabilityIndicator is only legal for 0 parameter methods (" + method.toGenericString() + ")"));
                Assert.isTrue((boolean)method.getReturnType().equals(Boolean.TYPE), (String)("CliAvailabilityIndicator is only legal for primitive boolean return types (" + method.toGenericString() + ")"));
                for (String cmd : availability.value()) {
                    Assert.isTrue((!this.availabilityIndicators.containsKey(cmd) ? 1 : 0) != 0, (String)("Cannot specify an availability indicator for '" + cmd + "' more than once"));
                    this.availabilityIndicators.put(cmd, new MethodTarget(method, command));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(CommandMarker command) {
        Object object = this.mutex;
        synchronized (object) {
            this.commands.remove(command);
            for (Method m : command.getClass().getMethods()) {
                CliAvailabilityIndicator availability = m.getAnnotation(CliAvailabilityIndicator.class);
                if (availability == null) continue;
                for (String cmd : availability.value()) {
                    this.availabilityIndicators.remove(cmd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Converter<?> converter) {
        Object object = this.mutex;
        synchronized (object) {
            this.converters.add(converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Converter<?> converter) {
        Object object = this.mutex;
        synchronized (object) {
            this.converters.remove(converter);
        }
    }
}

