/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientIdGenerator;
import org.apache.hadoop.hbase.client.NonceGenerator;

@InterfaceAudience.Private
public class PerClientRandomNonceGenerator
implements NonceGenerator {
    private final Random rdm = new Random();
    private final long clientId;

    public PerClientRandomNonceGenerator() {
        byte[] clientIdBase = ClientIdGenerator.generateClientId();
        this.clientId = ((long)Arrays.hashCode(clientIdBase) << 32) + (long)this.rdm.nextInt();
    }

    @Override
    public long getNonceGroup() {
        return this.clientId;
    }

    @Override
    public long newNonce() {
        long result = 0L;
        while ((result = this.rdm.nextLong()) == 0L) {
        }
        return result;
    }
}

