/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class OrientDBClient
extends DB {
    private static final String CLASS = "usertable";
    private ODatabaseDocumentTx db;
    private ODictionary<ORecordInternal<?>> dictionary;

    public void init() throws DBException {
        Properties props = this.getProperties();
        String url = System.getProperty("os.name").toLowerCase().contains("win") ? props.getProperty("orientdb.url", "plocal:C:/temp/databases/ycsb") : props.getProperty("orientdb.url", "plocal:/temp/databases/ycsb");
        String user = props.getProperty("orientdb.user", "admin");
        String password = props.getProperty("orientdb.password", "admin");
        Boolean newdb = Boolean.parseBoolean(props.getProperty("orientdb.newdb", "false"));
        try {
            System.out.println("OrientDB loading database url = " + url);
            OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)false);
            this.db = new ODatabaseDocumentTx(url);
            if (this.db.exists()) {
                this.db.open(user, password);
                if (newdb.booleanValue()) {
                    System.out.println("OrientDB drop and recreate fresh db");
                    this.db.drop();
                    this.db.create();
                }
            } else {
                System.out.println("OrientDB database not found, create fresh db");
                this.db.create();
            }
            System.out.println("OrientDB connection created with " + url);
            this.dictionary = this.db.getMetadata().getIndexManager().getDictionary();
            if (!this.db.getMetadata().getSchema().existsClass(CLASS)) {
                this.db.getMetadata().getSchema().createClass(CLASS);
            }
            this.db.declareIntent((OIntent)new OIntentMassiveInsert());
        }
        catch (Exception e1) {
            System.err.println("Could not initialize OrientDB connection pool for Loader: " + e1.toString());
            e1.printStackTrace();
            return;
        }
    }

    public void cleanup() throws DBException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            ODocument document = new ODocument(CLASS);
            for (Map.Entry entry : StringByteIterator.getStringMap(values).entrySet()) {
                document.field((String)entry.getKey(), entry.getValue());
            }
            document.save();
            this.dictionary.put(key, (Object)document);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int delete(String table, String key) {
        try {
            this.dictionary.remove(key);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        block6: {
            try {
                ODocument document = (ODocument)this.dictionary.get(key);
                if (document == null) break block6;
                if (fields != null) {
                    for (String field : fields) {
                        result.put(field, (ByteIterator)new StringByteIterator((String)document.field(field)));
                    }
                } else {
                    for (String field : document.fieldNames()) {
                        result.put(field, (ByteIterator)new StringByteIterator((String)document.field(field)));
                    }
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            ODocument document = (ODocument)this.dictionary.get(key);
            if (document != null) {
                for (Map.Entry entry : StringByteIterator.getStringMap(values).entrySet()) {
                    document.field((String)entry.getKey(), entry.getValue());
                }
                document.save();
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            OIndexCursor entries = this.dictionary.getIndex().iterateEntriesMajor((Object)startkey, true, true);
            while (entries.hasNext()) {
                Map.Entry entry = entries.nextEntry();
                ODocument document = (ODocument)((OIdentifiable)entry.getValue()).getRecord();
                HashMap<String, StringByteIterator> map = new HashMap<String, StringByteIterator>();
                result.add(map);
                for (String field : fields) {
                    map.put(field, new StringByteIterator((String)document.field(field)));
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }
}

