/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.listener;

import com.orientechnologies.common.concur.lock.OLock;
import com.orientechnologies.common.concur.lock.ONoLock;
import java.util.Collection;
import java.util.HashSet;

public abstract class OListenerManger<L> {
    private final Collection<L> listeners;
    private final OLock lock;

    public OListenerManger() {
        this(new HashSet(8), new ONoLock());
    }

    public OListenerManger(OLock iLock) {
        this.listeners = new HashSet<L>(8);
        this.lock = iLock;
    }

    public OListenerManger(Collection<L> iListeners, OLock iLock) {
        this.listeners = iListeners;
        this.lock = iLock;
    }

    public void registerListener(L iListener) {
        if (iListener != null) {
            this.lock.lock();
            try {
                this.listeners.add(iListener);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void unregisterListener(L iListener) {
        if (iListener != null) {
            this.lock.lock();
            try {
                this.listeners.remove(iListener);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void resetListeners() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterable<L> browseListeners() {
        return this.listeners;
    }

    public Iterable<L> getListenersCopy() {
        this.lock.lock();
        try {
            HashSet<L> hashSet = new HashSet<L>(this.listeners);
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public OLock getLock() {
        return this.lock;
    }
}

