/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.util.OPair;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OAbstractProfiler
extends OSharedResourceAbstract
implements OProfilerMBean {
    protected long recordingFrom = -1L;
    protected final Map<String, OProfilerHookValue> hooks = new ConcurrentHashMap<String, OProfilerHookValue>();
    protected final ConcurrentHashMap<String, String> dictionary = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, OProfilerMBean.METRIC_TYPE> types = new ConcurrentHashMap();

    public OAbstractProfiler() {
    }

    public OAbstractProfiler(OAbstractProfiler profiler) {
        this.hooks.putAll(profiler.hooks);
        this.dictionary.putAll(profiler.dictionary);
        this.types.putAll(profiler.types);
    }

    @Override
    public void shutdown() {
        this.stopRecording();
    }

    @Override
    public boolean startRecording() {
        if (this.isRecording()) {
            return false;
        }
        this.recordingFrom = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean stopRecording() {
        if (!this.isRecording()) {
            return false;
        }
        this.recordingFrom = -1L;
        return true;
    }

    @Override
    public boolean isRecording() {
        return this.recordingFrom > -1L;
    }

    @Override
    public void updateCounter(String iStatName, String iDescription, long iPlus) {
        this.updateCounter(iStatName, iDescription, iPlus, iStatName);
    }

    @Override
    public String getName() {
        return "profiler";
    }

    @Override
    public void startup() {
        this.startRecording();
    }

    @Override
    public String dump() {
        return null;
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        return null;
    }

    @Override
    public String[] getChronosAsString() {
        return null;
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public void setAutoDump(int iNewValue) {
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public Map<String, OPair<String, OProfilerMBean.METRIC_TYPE>> getMetadata() {
        HashMap<String, OPair<String, OProfilerMBean.METRIC_TYPE>> metadata = new HashMap<String, OPair<String, OProfilerMBean.METRIC_TYPE>>();
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            metadata.put(entry.getKey(), new OPair<Comparable, OProfilerMBean.METRIC_TYPE>((Comparable)((Object)entry.getValue()), this.types.get(entry.getKey())));
        }
        return metadata;
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType, OProfilerHookValue iHookValue) {
        this.registerHookValue(iName, iDescription, iType, iHookValue, iName);
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType, OProfilerHookValue iHookValue, String iMetadataName) {
        if (iName != null) {
            this.unregisterHookValue(iName);
            this.updateMetadata(iMetadataName, iDescription, iType);
            this.hooks.put(iName, iHookValue);
        }
    }

    @Override
    public void unregisterHookValue(String iName) {
        if (iName != null) {
            this.hooks.remove(iName);
        }
    }

    @Override
    public String getSystemMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("system.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getProcessMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("process.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getDatabaseMetric(String iDatabaseName, String iMetricName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("db.");
        buffer.append(iDatabaseName != null ? iDatabaseName : "*");
        buffer.append('.');
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    protected void updateMetadata(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }

    public static interface OProfilerHookValue {
        public Object getValue();
    }
}

