/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import java.util.Calendar;
import java.util.Date;

public class ODateTimeSerializer
implements OBinarySerializer<Date> {
    public static ODateTimeSerializer INSTANCE = new ODateTimeSerializer();
    public static final byte ID = 5;

    @Override
    public int getObjectSize(Date object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        longSerializer.serialize(calendar.getTimeInMillis(), stream, startPosition, new Object[0]);
    }

    @Override
    public Date deserialize(byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        calendar.setTimeInMillis(longSerializer.deserialize(stream, startPosition));
        return calendar.getTime();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNative(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        longSerializer.serializeNative(calendar.getTimeInMillis(), stream, startPosition, new Object[0]);
    }

    @Override
    public Date deserializeNative(byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        calendar.setTimeInMillis(longSerializer.deserializeNative(stream, startPosition));
        return calendar.getTime();
    }

    @Override
    public void serializeInDirectMemory(Date object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        longSerializer.serializeInDirectMemory(calendar.getTimeInMillis(), pointer, offset, new Object[0]);
    }

    @Override
    public Date deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        Calendar calendar = Calendar.getInstance();
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        calendar.setTimeInMillis(longSerializer.deserializeFromDirectMemory(pointer, offset));
        return calendar.getTime();
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 8;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Date preprocess(Date value, Object ... hints) {
        return value;
    }
}

