/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

class FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final UserGroupInformation ugi;
    private final String user;
    private final Set<String> groups;
    private final boolean isSuper;

    private static String toAccessControlString(INode inode) {
        return "\"" + inode.getFullPathName() + "\":" + inode.getUserName() + ":" + inode.getGroupName() + ":" + (inode.isDirectory() ? "d" : "-") + inode.getFsPermission();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi) {
        this.ugi = callerUgi;
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.ugi.getGroupNames()));
        this.groups = Collections.unmodifiableSet(s);
        this.user = this.ugi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuper) {
            throw new AccessControlException("Access denied for user " + this.user + ". Superuser privilege is required");
        }
    }

    void checkPermission(String path, INodeDirectory root, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        int ancestorIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", resolveLink=" + resolveLink));
        }
        INodesInPath inodesInPath = root.getINodesInPath(path, resolveLink);
        Snapshot snapshot = inodesInPath.getPathSnapshot();
        INode[] inodes = inodesInPath.getINodes();
        for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
        }
        this.checkTraverse(inodes, ancestorIndex, snapshot);
        INode last = inodes[inodes.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodes.length > 1 && last != null) {
            this.checkStickyBit(inodes[inodes.length - 2], last, snapshot);
        }
        if (ancestorAccess != null && inodes.length > 1) {
            this.check(inodes, ancestorIndex, snapshot, ancestorAccess);
        }
        if (parentAccess != null && inodes.length > 1) {
            this.check(inodes, inodes.length - 2, snapshot, parentAccess);
        }
        if (access != null) {
            this.check(last, snapshot, access);
        }
        if (subAccess != null) {
            this.checkSubAccess(last, snapshot, subAccess);
        }
        if (doCheckOwner) {
            this.checkOwner(last, snapshot);
        }
    }

    private void checkOwner(INode inode, Snapshot snapshot) throws AccessControlException {
        if (inode != null && this.user.equals(inode.getUserName(snapshot))) {
            return;
        }
        throw new AccessControlException("Permission denied");
    }

    private void checkTraverse(INode[] inodes, int last, Snapshot snapshot) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], snapshot, FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(INode inode, Snapshot snapshot, FsAction access) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            this.check(d, snapshot, access);
            for (INode child : d.getChildrenList(snapshot)) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(INode[] inodes, int i, Snapshot snapshot, FsAction access) throws AccessControlException {
        this.check(i >= 0 ? inodes[i] : null, snapshot, access);
    }

    private void check(INode inode, Snapshot snapshot, FsAction access) throws AccessControlException {
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission(snapshot);
        if (this.user.equals(inode.getUserName(snapshot)) ? mode.getUserAction().implies(access) : (this.groups.contains(inode.getGroupName(snapshot)) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException("Permission denied: user=" + this.user + ", access=" + access + ", inode=" + FSPermissionChecker.toAccessControlString(inode));
    }

    private void checkStickyBit(INode parent, INode inode, Snapshot snapshot) throws AccessControlException {
        if (!parent.getFsPermission(snapshot).getStickyBit()) {
            return;
        }
        if (parent.getUserName(snapshot).equals(this.user)) {
            return;
        }
        if (inode.getUserName(snapshot).equals(this.user)) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + this.user + ", inode=" + inode);
    }
}

