/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

@InterfaceAudience.Private
public class INodeFileUnderConstructionWithSnapshot
extends INodeFileUnderConstruction
implements FileWithSnapshot {
    private final FileWithSnapshot.FileDiffList diffs;
    private boolean isCurrentFileDeleted = false;

    INodeFileUnderConstructionWithSnapshot(INodeFile f, String clientName, String clientMachine, DatanodeDescriptor clientNode, FileWithSnapshot.FileDiffList diffs) {
        super(f, clientName, clientMachine, clientNode);
        this.diffs = diffs != null ? diffs : new FileWithSnapshot.FileDiffList();
    }

    public INodeFileUnderConstructionWithSnapshot(INodeFileUnderConstruction f, FileWithSnapshot.FileDiffList diffs) {
        this(f, f.getClientName(), f.getClientMachine(), f.getClientNode(), diffs);
    }

    @Override
    protected INodeFileWithSnapshot toINodeFile(long mtime) {
        this.assertAllBlocksComplete();
        long atime = this.getModificationTime();
        INodeFileWithSnapshot f = new INodeFileWithSnapshot(this, this.getDiffs());
        f.setModificationTime(mtime);
        f.setAccessTime(atime);
        return f;
    }

    @Override
    public boolean isCurrentFileDeleted() {
        return this.isCurrentFileDeleted;
    }

    @Override
    public void deleteCurrentFile() {
        this.isCurrentFileDeleted = true;
    }

    @Override
    public INodeFileAttributes getSnapshotINode(Snapshot snapshot) {
        return this.diffs.getSnapshotINode(snapshot, this);
    }

    @Override
    public INodeFileUnderConstructionWithSnapshot recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest) && !this.shouldRecordInSrcSnapshot(latest)) {
            this.diffs.saveSelf2Snapshot(latest, this, null);
        }
        return this;
    }

    @Override
    public INodeFile asINodeFile() {
        return this;
    }

    @Override
    public FileWithSnapshot.FileDiffList getDiffs() {
        return this.diffs;
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
        if (snapshot == null) {
            this.recordModification(prior, null);
            this.isCurrentFileDeleted = true;
            FileWithSnapshot.Util.collectBlocksAndClear(this, collectedBlocks, removedINodes);
            return Quota.Counts.newInstance();
        }
        prior = this.getDiffs().updatePrior(snapshot, prior);
        return this.diffs.deleteSnapshotDiff(snapshot, prior, this, collectedBlocks, removedINodes, countDiffChange);
    }

    @Override
    public String toDetailString() {
        return super.toDetailString() + (this.isCurrentFileDeleted() ? " (DELETED), " : ", ") + this.diffs;
    }
}

