/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class AerospikeClient
extends DB {
    private static final boolean DEBUG = false;
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "3000";
    private static final String DEFAULT_TIMEOUT = "10000";
    private static final String DEFAULT_NAMESPACE = "ycsb";
    private static final int RESULT_OK = 0;
    private static final int RESULT_ERROR = -1;
    private static final int WRITE_OVERLOAD_DELAY = 5;
    private static final int WRITE_OVERLOAD_TRIES = 3;
    private String namespace = null;
    private com.aerospike.client.AerospikeClient client = null;
    private Policy readPolicy = new Policy();
    private WritePolicy insertPolicy = new WritePolicy();
    private WritePolicy updatePolicy = new WritePolicy();
    private WritePolicy deletePolicy = new WritePolicy();

    public void init() throws DBException {
        int timeout;
        this.insertPolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.updatePolicy.recordExistsAction = RecordExistsAction.UPDATE_ONLY;
        Properties props = this.getProperties();
        this.namespace = props.getProperty("as.namespace", DEFAULT_NAMESPACE);
        String host = props.getProperty("as.host", DEFAULT_HOST);
        String user = props.getProperty("as.user");
        String password = props.getProperty("as.password");
        int port = Integer.parseInt(props.getProperty("as.port", DEFAULT_PORT));
        this.readPolicy.timeout = timeout = Integer.parseInt(props.getProperty("as.timeout", DEFAULT_TIMEOUT));
        this.insertPolicy.timeout = timeout;
        this.updatePolicy.timeout = timeout;
        this.deletePolicy.timeout = timeout;
        ClientPolicy clientPolicy = new ClientPolicy();
        if (user != null && password != null) {
            clientPolicy.user = user;
            clientPolicy.password = password;
        }
        try {
            this.client = new com.aerospike.client.AerospikeClient(clientPolicy, host, port);
        }
        catch (AerospikeException e) {
            throw new DBException(String.format("Error while creating Aerospike client for %s:%d.", host, port), (Throwable)e);
        }
    }

    public void cleanup() throws DBException {
        this.client.close();
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            Record record = fields != null ? this.client.get(this.readPolicy, new Key(this.namespace, table, key), fields.toArray(new String[fields.size()])) : this.client.get(this.readPolicy, new Key(this.namespace, table, key));
            if (record == null) {
                return -1;
            }
            for (Map.Entry entry : record.bins.entrySet()) {
                result.put((String)entry.getKey(), (ByteIterator)new ByteArrayByteIterator((byte[])entry.getValue()));
            }
            return 0;
        }
        catch (AerospikeException e) {
            System.err.println("Error while reading key " + key + ": " + (Object)((Object)e));
            return -1;
        }
    }

    public int scan(String table, String start, int count, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        System.err.println("Scan not implemented");
        return -1;
    }

    private int write(String table, String key, WritePolicy writePolicy, HashMap<String, ByteIterator> values) {
        Bin[] bins = new Bin[values.size()];
        int index = 0;
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            bins[index] = new Bin(entry.getKey(), entry.getValue().toArray());
            ++index;
        }
        int delay = 5;
        Key keyObj = new Key(this.namespace, table, key);
        for (int tries = 0; tries < 3; ++tries) {
            try {
                this.client.put(writePolicy, keyObj, bins);
                return 0;
            }
            catch (AerospikeException e) {
                if (e.getResultCode() != 18) {
                    System.err.println("Error while writing key " + key + ": " + (Object)((Object)e));
                    return -1;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                delay *= 2;
                continue;
            }
        }
        return -1;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        return this.write(table, key, this.updatePolicy, values);
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        return this.write(table, key, this.insertPolicy, values);
    }

    public int delete(String table, String key) {
        try {
            if (!this.client.delete(this.deletePolicy, new Key(this.namespace, table, key))) {
                return -1;
            }
            return 0;
        }
        catch (AerospikeException e) {
            System.err.println("Error while deleting key " + key + ": " + (Object)((Object)e));
            return -1;
        }
    }
}

