/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.hadoop.mapreduce.Job;

public class ClientOnRequiredTable
extends ClientOpts {
    @Parameter(names={"-t", "--table"}, required=true, description="table to use")
    public String tableName = null;
    @Parameter(names={"-tf", "--tokenFile"}, description="File in hdfs containing the user's authentication token create with \"bin/accumulo create-token\"")
    public String tokenFile = "";

    @Override
    public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
        super.setAccumuloConfigs(job);
        if (this.tokenFile.isEmpty()) {
            AccumuloInputFormat.setConnectorInfo(job, this.principal, this.getToken());
            AccumuloOutputFormat.setConnectorInfo(job, this.principal, this.getToken());
        } else {
            AccumuloInputFormat.setConnectorInfo(job, this.principal, this.tokenFile);
            AccumuloOutputFormat.setConnectorInfo(job, this.principal, this.tokenFile);
        }
        AccumuloInputFormat.setInputTableName(job, this.tableName);
        AccumuloInputFormat.setScanAuthorizations(job, this.auths);
        AccumuloOutputFormat.setCreateTables(job, true);
        AccumuloOutputFormat.setDefaultTableName(job, this.tableName);
    }
}

