/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class Writer {
    private static final Logger log = Logger.getLogger(Writer.class);
    private Instance instance;
    private Credentials credentials;
    private Text table;

    public Writer(Instance instance, Credentials credentials, Text table) {
        ArgumentChecker.notNull(instance, credentials, table);
        this.instance = instance;
        this.credentials = credentials;
        this.table = table;
    }

    public Writer(Instance instance, Credentials credentials, String table) {
        this(instance, credentials, new Text(table));
    }

    private static void updateServer(Instance instance, Mutation m, KeyExtent extent, String server, Credentials ai, AccumuloConfiguration configuration) throws TException, NotServingTabletException, ConstraintViolationException, AccumuloSecurityException {
        ArgumentChecker.notNull(m, extent, server, ai);
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(server, configuration);
            client.update(Tracer.traceInfo(), ai.toThrift(instance), extent.toThrift(), m.toThrift());
            return;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code);
        }
        finally {
            ThriftUtil.returnClient(client);
        }
    }

    public void update(Mutation m) throws AccumuloException, AccumuloSecurityException, ConstraintViolationException, TableNotFoundException {
        ArgumentChecker.notNull(m);
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        while (true) {
            TabletLocator.TabletLocation tabLoc;
            if ((tabLoc = TabletLocator.getLocator(this.instance, this.table).locateTablet(this.credentials, new Text(m.getRow()), false, true)) == null) {
                log.trace((Object)("No tablet location found for row " + new String(m.getRow(), Constants.UTF8)));
                UtilWaitThread.sleep(500L);
                continue;
            }
            try {
                Writer.updateServer(this.instance, m, tabLoc.tablet_extent, tabLoc.tablet_location, this.credentials, ServerConfigurationUtil.getConfiguration(this.instance));
                return;
            }
            catch (NotServingTabletException e) {
                log.trace((Object)("Not serving tablet, server = " + tabLoc.tablet_location));
                TabletLocator.getLocator(this.instance, this.table).invalidateCache(tabLoc.tablet_extent);
            }
            catch (TException e) {
                log.error((Object)("error sending update to " + tabLoc.tablet_location + ": " + (Object)((Object)e)));
                TabletLocator.getLocator(this.instance, this.table).invalidateCache(tabLoc.tablet_extent);
            }
            UtilWaitThread.sleep(500L);
        }
    }
}

