/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class InputTableConfig
implements Writable {
    private List<IteratorSetting> iterators;
    private List<Range> ranges;
    private Collection<Pair<Text, Text>> columns;
    private boolean autoAdjustRanges = true;
    private boolean useLocalIterators = false;
    private boolean useIsolatedScanners = false;
    private boolean offlineScan = false;

    public InputTableConfig() {
    }

    public InputTableConfig(DataInput input) throws IOException {
        this.readFields(input);
    }

    public InputTableConfig setRanges(List<Range> ranges) {
        this.ranges = ranges;
        return this;
    }

    public List<Range> getRanges() {
        return this.ranges != null ? this.ranges : new ArrayList<Range>();
    }

    public InputTableConfig fetchColumns(Collection<Pair<Text, Text>> columns) {
        this.columns = columns;
        return this;
    }

    public Collection<Pair<Text, Text>> getFetchedColumns() {
        return this.columns != null ? this.columns : new HashSet<Pair<Text, Text>>();
    }

    public InputTableConfig setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
        return this;
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators != null ? this.iterators : new ArrayList<IteratorSetting>();
    }

    public InputTableConfig setAutoAdjustRanges(boolean autoAdjustRanges) {
        this.autoAdjustRanges = autoAdjustRanges;
        return this;
    }

    public boolean shouldAutoAdjustRanges() {
        return this.autoAdjustRanges;
    }

    public InputTableConfig setUseLocalIterators(boolean useLocalIterators) {
        this.useLocalIterators = useLocalIterators;
        return this;
    }

    public boolean shouldUseLocalIterators() {
        return this.useLocalIterators;
    }

    public InputTableConfig setOfflineScan(boolean offlineScan) {
        this.offlineScan = offlineScan;
        return this;
    }

    public boolean isOfflineScan() {
        return this.offlineScan;
    }

    public InputTableConfig setUseIsolatedScanners(boolean useIsolatedScanners) {
        this.useIsolatedScanners = useIsolatedScanners;
        return this;
    }

    public boolean shouldUseIsolatedScanners() {
        return this.useIsolatedScanners;
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (this.iterators != null) {
            dataOutput.writeInt(this.iterators.size());
            for (IteratorSetting iteratorSetting : this.iterators) {
                iteratorSetting.write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.ranges != null) {
            dataOutput.writeInt(this.ranges.size());
            for (Range range : this.ranges) {
                range.write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.columns != null) {
            dataOutput.writeInt(this.columns.size());
            for (Pair pair : this.columns) {
                if (pair.getSecond() == null) {
                    dataOutput.writeInt(1);
                    ((Text)pair.getFirst()).write(dataOutput);
                    continue;
                }
                dataOutput.writeInt(2);
                ((Text)pair.getFirst()).write(dataOutput);
                ((Text)pair.getSecond()).write(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        dataOutput.writeBoolean(this.autoAdjustRanges);
        dataOutput.writeBoolean(this.useLocalIterators);
        dataOutput.writeBoolean(this.useIsolatedScanners);
    }

    public void readFields(DataInput dataInput) throws IOException {
        long iterSize = dataInput.readInt();
        if (iterSize > 0L) {
            this.iterators = new ArrayList<IteratorSetting>();
        }
        int i = 0;
        while ((long)i < iterSize) {
            this.iterators.add(new IteratorSetting(dataInput));
            ++i;
        }
        long rangeSize = dataInput.readInt();
        if (rangeSize > 0L) {
            this.ranges = new ArrayList<Range>();
        }
        int i2 = 0;
        while ((long)i2 < rangeSize) {
            Range range = new Range();
            range.readFields(dataInput);
            this.ranges.add(range);
            ++i2;
        }
        long columnSize = dataInput.readInt();
        if (columnSize > 0L) {
            this.columns = new HashSet<Pair<Text, Text>>();
        }
        int i3 = 0;
        while ((long)i3 < columnSize) {
            long numPairs = dataInput.readInt();
            Text colFam = new Text();
            colFam.readFields(dataInput);
            if (numPairs == 1L) {
                this.columns.add(new Pair<Text, Object>(colFam, null));
            } else if (numPairs == 2L) {
                Text colQual = new Text();
                colQual.readFields(dataInput);
                this.columns.add(new Pair<Text, Text>(colFam, colQual));
            }
            ++i3;
        }
        this.autoAdjustRanges = dataInput.readBoolean();
        this.useLocalIterators = dataInput.readBoolean();
        this.useIsolatedScanners = dataInput.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputTableConfig that = (InputTableConfig)o;
        if (this.autoAdjustRanges != that.autoAdjustRanges) {
            return false;
        }
        if (this.offlineScan != that.offlineScan) {
            return false;
        }
        if (this.useIsolatedScanners != that.useIsolatedScanners) {
            return false;
        }
        if (this.useLocalIterators != that.useLocalIterators) {
            return false;
        }
        if (this.columns != null ? !((Object)this.columns).equals(that.columns) : that.columns != null) {
            return false;
        }
        if (this.iterators != null ? !((Object)this.iterators).equals(that.iterators) : that.iterators != null) {
            return false;
        }
        return !(this.ranges != null ? !((Object)this.ranges).equals(that.ranges) : that.ranges != null);
    }

    public int hashCode() {
        int result = 31 * (this.iterators != null ? ((Object)this.iterators).hashCode() : 0);
        result = 31 * result + (this.ranges != null ? ((Object)this.ranges).hashCode() : 0);
        result = 31 * result + (this.columns != null ? ((Object)this.columns).hashCode() : 0);
        result = 31 * result + (this.autoAdjustRanges ? 1 : 0);
        result = 31 * result + (this.useLocalIterators ? 1 : 0);
        result = 31 * result + (this.useIsolatedScanners ? 1 : 0);
        result = 31 * result + (this.offlineScan ? 1 : 0);
        return result;
    }
}

