/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.hadoop.conf.Configuration;

public class OutputConfigurator
extends ConfiguratorBase {
    public static void setDefaultTableName(Class<?> implementingClass, Configuration conf, String tableName) {
        if (tableName != null) {
            conf.set(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.DEFAULT_TABLE_NAME), tableName);
        }
    }

    public static String getDefaultTableName(Class<?> implementingClass, Configuration conf) {
        return conf.get(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.DEFAULT_TABLE_NAME));
    }

    public static void setBatchWriterOptions(Class<?> implementingClass, Configuration conf, BatchWriterConfig bwConfig) {
        String serialized;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            bwConfig.write(new DataOutputStream(baos));
            serialized = new String(baos.toByteArray(), Constants.UTF8);
            baos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to serialize " + BatchWriterConfig.class.getName());
        }
        conf.set(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.BATCH_WRITER_CONFIG), serialized);
    }

    public static BatchWriterConfig getBatchWriterOptions(Class<?> implementingClass, Configuration conf) {
        String serialized = conf.get(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.BATCH_WRITER_CONFIG));
        BatchWriterConfig bwConfig = new BatchWriterConfig();
        if (serialized == null || serialized.isEmpty()) {
            return bwConfig;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(serialized.getBytes(Constants.UTF8));
            bwConfig.readFields(new DataInputStream(bais));
            bais.close();
            return bwConfig;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to serialize " + BatchWriterConfig.class.getName());
        }
    }

    public static void setCreateTables(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.CAN_CREATE_TABLES), enableFeature);
    }

    public static Boolean canCreateTables(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.CAN_CREATE_TABLES), false);
    }

    public static void setSimulationMode(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.SIMULATION_MODE), enableFeature);
    }

    public static Boolean getSimulationMode(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.SIMULATION_MODE), false);
    }

    public static enum Features {
        CAN_CREATE_TABLES,
        SIMULATION_MODE;

    }

    public static enum WriteOpts {
        DEFAULT_TABLE_NAME,
        BATCH_WRITER_CONFIG;

    }
}

