/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.Property;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(SiteConfiguration.class);
    private static AccumuloConfiguration parent = null;
    private static SiteConfiguration instance = null;
    private static Configuration xmlConfig;

    private SiteConfiguration(AccumuloConfiguration parent) {
        SiteConfiguration.parent = parent;
    }

    public static synchronized SiteConfiguration getInstance(AccumuloConfiguration parent) {
        if (instance == null) {
            instance = new SiteConfiguration(parent);
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    private static synchronized Configuration getXmlConfig() {
        String configFile = System.getProperty("org.apache.accumulo.config.file", "accumulo-site.xml");
        if (xmlConfig == null) {
            xmlConfig = new Configuration(false);
            if (SiteConfiguration.class.getClassLoader().getResource(configFile) == null) {
                log.warn((Object)(configFile + " not found on classpath"), new Throwable());
            } else {
                xmlConfig.addResource(configFile);
            }
        }
        return xmlConfig;
    }

    @Override
    public String get(Property property) {
        String key = property.getKey();
        String value = SiteConfiguration.getXmlConfig().get(key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + (Object)((Object)property.getType()) + ": " + value));
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        parent.getProperties(props, filter);
        for (Map.Entry entry : SiteConfiguration.getXmlConfig()) {
            if (!filter.accept((String)entry.getKey())) continue;
            props.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void clear() {
        SiteConfiguration.getXmlConfig().clear();
    }

    public synchronized void clearAndNull() {
        if (xmlConfig != null) {
            xmlConfig.clear();
            xmlConfig = null;
        }
    }

    public void set(Property property, String value) {
        this.set(property.getKey(), value);
    }

    public void set(String key, String value) {
        SiteConfiguration.getXmlConfig().set(key, value);
    }
}

