/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class VisibilityFilter
extends Filter {
    protected VisibilityEvaluator ve;
    protected Text defaultVisibility;
    protected LRUMap cache;
    protected Text tmpVis;
    protected Authorizations authorizations;
    private static final Logger log = Logger.getLogger(VisibilityFilter.class);

    public VisibilityFilter() {
    }

    public VisibilityFilter(SortedKeyValueIterator<Key, Value> iterator, Authorizations authorizations, byte[] defaultVisibility) {
        this.setSource(iterator);
        this.ve = new VisibilityEvaluator(authorizations);
        this.authorizations = authorizations;
        this.defaultVisibility = new Text(defaultVisibility);
        this.cache = new LRUMap(1000);
        this.tmpVis = new Text();
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new VisibilityFilter(this.getSource().deepCopy(env), this.authorizations, TextUtil.getBytes(this.defaultVisibility));
    }

    @Override
    public boolean accept(Key k, Value v) {
        Boolean b;
        Text testVis = k.getColumnVisibility(this.tmpVis);
        if (testVis.getLength() == 0 && this.defaultVisibility.getLength() == 0) {
            return true;
        }
        if (testVis.getLength() == 0) {
            testVis = this.defaultVisibility;
        }
        if ((b = (Boolean)this.cache.get((Object)testVis)) != null) {
            return b;
        }
        try {
            Boolean bb = this.ve.evaluate(new ColumnVisibility(testVis));
            this.cache.put((Object)new Text(testVis), (Object)bb);
            return bb;
        }
        catch (VisibilityParseException e) {
            log.error((Object)"Parse Error", (Throwable)e);
            return false;
        }
        catch (BadArgumentException e) {
            log.error((Object)"Parse Error", (Throwable)e);
            return false;
        }
    }
}

