/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class SecurityUtil {
    private static final Logger log = Logger.getLogger(SecurityUtil.class);
    public static boolean usingKerberos = false;

    public static void serverLogin(AccumuloConfiguration acuConf) {
        String keyTab = acuConf.getPath(Property.GENERAL_KERBEROS_KEYTAB);
        if (keyTab == null || keyTab.length() == 0) {
            return;
        }
        usingKerberos = true;
        String principalConfig = acuConf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
        if (principalConfig == null || principalConfig.length() == 0) {
            return;
        }
        if (SecurityUtil.login(principalConfig, keyTab)) {
            try {
                UserGroupInformation.getLoginUser();
            }
            catch (IOException io) {
                log.error((Object)"Error starting up renewal thread. This shouldn't be happenining.", (Throwable)io);
            }
        }
    }

    public static boolean login(String principalConfig, String keyTabPath) {
        try {
            String principalName = org.apache.hadoop.security.SecurityUtil.getServerPrincipal((String)principalConfig, (String)InetAddress.getLocalHost().getCanonicalHostName());
            if (keyTabPath != null && principalName != null && keyTabPath.length() != 0 && principalName.length() != 0) {
                UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keyTabPath);
                log.info((Object)("Succesfully logged in as user " + principalConfig));
                return true;
            }
        }
        catch (IOException io) {
            log.error((Object)("Error logging in user " + principalConfig + " using keytab at " + keyTabPath), (Throwable)io);
        }
        return false;
    }
}

