/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.log4j.Logger;

public class FormatterFactory {
    private static final Logger log = Logger.getLogger(FormatterFactory.class);

    public static Formatter getFormatter(Class<? extends Formatter> formatterClass, Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        Formatter formatter = null;
        try {
            formatter = formatterClass.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)"Unable to instantiate formatter. Using default formatter.", (Throwable)e);
            formatter = new DefaultFormatter();
        }
        formatter.initialize(scanner, printTimestamps);
        return formatter;
    }

    public static Formatter getDefaultFormatter(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        return FormatterFactory.getFormatter(DefaultFormatter.class, scanner, printTimestamps);
    }

    private FormatterFactory() {
    }
}

