/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class ShellOptionsJC {
    public static final Logger log = Logger.getLogger(Shell.class);
    @Parameter(names={"-u", "--user"}, description="username (defaults to your OS user)")
    private String username = System.getProperty("user.name", "root");
    @Parameter(names={"-p", "--password"}, description="password (can be specified as 'pass:<password>', 'file:<local file containing the password>', 'env:<variable containing the pass>', or stdin)", converter=PasswordConverter.class)
    private String password;
    @Parameter(names={"-tc", "--tokenClass"}, description="token type to create, use the -l to pass options", converter=TokenConverter.class)
    private AuthenticationToken authenticationToken;
    @DynamicParameter(names={"-l", "--tokenProperty"}, description="login properties in the format key=value. Reuse -l for each property")
    private Map<String, String> tokenProperties = new TreeMap<String, String>();
    @Parameter(names={"--disable-tab-completion"}, description="disables tab completion (for less overhead when scripting)")
    private boolean tabCompletionDisabled;
    @Parameter(names={"--debug"}, description="enables client debugging")
    private boolean debugEnabled;
    @Parameter(names={"--fake"}, description="fake a connection to accumulo")
    private boolean fake;
    @Parameter(names={"-?", "--help"}, help=true, description="display this help")
    private boolean helpEnabled;
    @Parameter(names={"-e", "--execute-command"}, description="executes a command, and then exits")
    private String execCommand;
    @Parameter(names={"-f", "--execute-file"}, description="executes commands from a file at startup", converter=FileConverter.class)
    private File execFile;
    @Parameter(names={"-fv", "--execute-file-verbose"}, description="executes commands from a file at startup, with commands shown", converter=FileConverter.class)
    private File execFileVerbose;
    @Parameter(names={"-h", "--hdfsZooInstance"}, description="use hdfs zoo instance")
    private boolean hdfsZooInstance;
    @Parameter(names={"-z", "--zooKeeperInstance"}, description="use a zookeeper instance with the given instance name and list of zoo hosts", arity=2)
    private List<String> zooKeeperInstance = new ArrayList<String>();
    @Parameter(names={"--ssl"}, description="use ssl to connect to accumulo")
    private boolean useSsl = false;
    @Parameter(names={"--config-file"}, description="read the given client config file.  If omitted, the path searched can be specified with $ACCUMULO_CLIENT_CONF_PATH, which defaults to ~/.accumulo/config:$ACCUMULO_CONF_DIR/client.conf:/etc/accumulo/client.conf")
    private String clientConfigFile = null;
    @Parameter(names={"-zi", "--zooKeeperInstanceName"}, description="use a zookeeper instance with the given instance name")
    private String zooKeeperInstanceName;
    @Parameter(names={"-zh", "--zooKeeperHosts"}, description="use a zookeeper instance with the given list of zoo hosts")
    private String zooKeeperHosts;
    @Parameter(names={"--auth-timeout"}, description="minutes the shell can be idle without re-entering a password")
    private int authTimeout = 60;
    @Parameter(names={"--disable-auth-timeout"}, description="disables requiring the user to re-type a password after being idle")
    private boolean authTimeoutDisabled;
    @Parameter(hidden=true)
    private List<String> unrecognizedOptions;

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.authenticationToken;
    }

    public Map<String, String> getTokenProperties() {
        return this.tokenProperties;
    }

    public boolean isTabCompletionDisabled() {
        return this.tabCompletionDisabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isFake() {
        return this.fake;
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public File getExecFile() {
        return this.execFile;
    }

    public File getExecFileVerbose() {
        return this.execFileVerbose;
    }

    public boolean isHdfsZooInstance() {
        return this.hdfsZooInstance;
    }

    public List<String> getZooKeeperInstance() {
        return this.zooKeeperInstance;
    }

    public String getZooKeeperInstanceName() {
        return this.zooKeeperInstanceName;
    }

    public String getZooKeeperHosts() {
        return this.zooKeeperHosts;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public boolean isAuthTimeoutDisabled() {
        return this.authTimeoutDisabled;
    }

    public List<String> getUnrecognizedOptions() {
        return this.unrecognizedOptions;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String getClientConfigFile() {
        return this.clientConfigFile;
    }

    public ClientConfiguration getClientConfiguration() throws ConfigurationException, FileNotFoundException {
        ClientConfiguration clientConfig;
        ClientConfiguration clientConfiguration = clientConfig = this.clientConfigFile == null ? ClientConfiguration.loadDefault() : new ClientConfiguration(new Configuration[]{new PropertiesConfiguration(this.getClientConfigFile())});
        if (this.useSsl()) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
        }
        return clientConfig;
    }

    public static class TokenConverter
    implements IStringConverter<AuthenticationToken> {
        public AuthenticationToken convert(String value) {
            try {
                return Class.forName(value).asSubclass(AuthenticationToken.class).newInstance();
            }
            catch (Exception e) {
                throw new ParameterException((Throwable)e);
            }
        }
    }

    public static class PasswordConverter
    implements IStringConverter<String> {
        public static final String STDIN = "stdin";

        public String convert(String value) {
            for (KeyType keyType : KeyType.values()) {
                if (!keyType.matches(value)) continue;
                return keyType.convert(value);
            }
            return value;
        }

        private static enum KeyType {
            PASS("pass:"),
            ENV("env:"){

                @Override
                String process(String value) {
                    return System.getenv(value);
                }
            }
            ,
            FILE("file:"){

                @Override
                String process(String value) {
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(new File(value));
                        String string = scanner.nextLine();
                        return string;
                    }
                    catch (FileNotFoundException e) {
                        throw new ParameterException((Throwable)e);
                    }
                    finally {
                        if (scanner != null) {
                            scanner.close();
                        }
                    }
                }
            }
            ,
            STDIN("stdin"){

                @Override
                public boolean matches(String value) {
                    return this.prefix.equals(value);
                }

                @Override
                public String convert(String value) {
                    return this.prefix;
                }
            };

            String prefix;

            private KeyType(String prefix) {
                this.prefix = prefix;
            }

            public boolean matches(String value) {
                return value.startsWith(this.prefix);
            }

            public String convert(String value) {
                return this.process(value.substring(this.prefix.length()));
            }

            String process(String value) {
                return value;
            }
        }
    }
}

