/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.volume.Volume;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class VolumeImpl
implements Volume {
    private static final Logger log = Logger.getLogger(VolumeImpl.class);
    protected final FileSystem fs;
    protected final String basePath;

    public VolumeImpl(Path path, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)conf);
        this.fs = path.getFileSystem(conf);
        this.basePath = path.toUri().getPath();
    }

    public VolumeImpl(FileSystem fs, String basePath) {
        Preconditions.checkNotNull((Object)fs);
        Preconditions.checkNotNull((Object)basePath);
        this.fs = fs;
        this.basePath = basePath;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public Path prefixChild(Path p) {
        return new Path(this.basePath, p);
    }

    @Override
    public boolean isValidPath(Path p) {
        Preconditions.checkNotNull((Object)p);
        try {
            if (this.fs.equals(p.getFileSystem(CachedConfiguration.getInstance()))) {
                return p.toUri().getPath().startsWith(this.basePath);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Could not determine filesystem from path: " + p));
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof VolumeImpl) {
            VolumeImpl other = (VolumeImpl)o;
            return this.getFileSystem().equals(other.getFileSystem()) && this.getBasePath().equals(other.getBasePath());
        }
        return false;
    }

    public String toString() {
        return this.getFileSystem() + " " + this.basePath;
    }

    @Override
    public Path prefixChild(String p) {
        return new Path(this.basePath, p);
    }
}

