/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.internal.FinishBackupResponse;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.admin.remote.AdminFailureResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class FinishBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();
    private File targetDir;
    private File baselineDir;

    public FinishBackupRequest() {
    }

    public FinishBackupRequest(File targetDir, File baselineDir) {
        this.targetDir = targetDir;
        this.baselineDir = baselineDir;
    }

    public static Map<DistributedMember, Set<PersistentID>> send(DM dm, Set recipients, File targetDir, File baselineDir) {
        FinishBackupRequest request = new FinishBackupRequest(targetDir, baselineDir);
        request.setRecipients(recipients);
        FinishBackupReplyProcessor replyProcessor = new FinishBackupReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AdminResponse response = request.createResponse((DistributionManager)dm);
        response.setSender(dm.getDistributionManagerId());
        replyProcessor.process(response);
        return replyProcessor.results;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> persistentIds;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            persistentIds = new HashSet();
        } else {
            try {
                persistentIds = cache.getBackupManager().finishBackup(this.targetDir, this.baselineDir);
            }
            catch (IOException e) {
                logger.error(LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
                return AdminFailureResponse.create(dm, this.getSender(), e);
            }
        }
        return new FinishBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2114;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.targetDir = DataSerializer.readFile(in);
        this.baselineDir = DataSerializer.readFile(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeFile(this.targetDir, out);
        DataSerializer.writeFile(this.baselineDir, out);
    }

    private static class FinishBackupReplyProcessor
    extends AdminMultipleReplyProcessor {
        Map<DistributedMember, Set<PersistentID>> results = Collections.synchronizedMap(new HashMap());

        public FinishBackupReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        protected int getAckWaitThreshold() {
            return 0;
        }

        @Override
        public long getAckSevereAlertThresholdMS() {
            return Long.MAX_VALUE;
        }

        @Override
        protected void process(DistributionMessage msg, boolean warn) {
            HashSet<PersistentID> persistentIds;
            if (msg instanceof FinishBackupResponse && (persistentIds = ((FinishBackupResponse)msg).getPersistentIds()) != null && !persistentIds.isEmpty()) {
                this.results.put(msg.getSender(), persistentIds);
            }
            super.process(msg, warn);
        }
    }
}

