/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheEventImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberRegionEventImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class SystemMemberCacheEventProcessor {
    private static final Logger logger = LogService.getLogger();

    public static void send(Cache c, Operation op) {
        SystemMemberCacheEventProcessor.send(c, null, op);
    }

    public static void send(Cache c, Region region, Operation op) {
        InternalDistributedSystem system = (InternalDistributedSystem)c.getDistributedSystem();
        Set recps = system.getDistributionManager().getAdminMemberSet();
        if (recps.isEmpty()) {
            return;
        }
        SystemMemberCacheMessage msg = new SystemMemberCacheMessage();
        msg.regionPath = region == null ? null : region.getFullPath();
        msg.setRecipients(recps);
        msg.op = op;
        system.getDistributionManager().putOutgoing(msg);
    }

    public static final class SystemMemberCacheMessage
    extends HighPriorityDistributionMessage {
        protected String regionPath;
        protected Operation op;

        @Override
        protected void process(DistributionManager dm) {
            AdminDistributedSystemImpl admin = AdminDistributedSystemImpl.getConnectedInstance();
            if (admin == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring message because there is no admin distributed system present: {}", this);
                }
                return;
            }
            List listeners = admin.getCacheListeners();
            Iterator itr = listeners.iterator();
            SystemMemberCacheListener listener = null;
            while (itr.hasNext()) {
                SystemMemberCacheEventImpl event;
                listener = (SystemMemberCacheListener)itr.next();
                if (this.regionPath == null) {
                    event = new SystemMemberCacheEventImpl(this.getSender(), this.op);
                    if (this.op == Operation.CACHE_CREATE) {
                        listener.afterCacheCreate(event);
                        continue;
                    }
                    listener.afterCacheClose(event);
                    continue;
                }
                event = new SystemMemberRegionEventImpl(this.getSender(), this.op, this.regionPath);
                if (this.op.isRegionDestroy()) {
                    listener.afterRegionLoss((SystemMemberRegionEvent)((Object)event));
                    continue;
                }
                listener.afterRegionCreate((SystemMemberRegionEvent)((Object)event));
            }
        }

        @Override
        public int getDSFID() {
            return 86;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.op = Operation.fromOrdinal(in.readByte());
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            out.writeByte(this.op.ordinal);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("SystemMemberCacheMessage (region='");
            buff.append(this.regionPath);
            buff.append("'; sender=");
            buff.append(this.sender);
            buff.append("; op=");
            buff.append(this.op);
            buff.append(")");
            return buff.toString();
        }
    }
}

