/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheDoesNotExistException;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.admin.Statistic;
import com.gemstone.gemfire.admin.SystemMemberBridgeServer;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.internal.StatisticImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberBridgeServerImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberRegionImpl;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ObjIdMap;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.admin.CacheInfo;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.Stat;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class SystemMemberCacheImpl
implements SystemMemberCache {
    protected final GemFireVM vm;
    protected CacheInfo info;
    protected Statistic[] statistics;
    private ObjIdMap bridgeServers = new ObjIdMap();

    public SystemMemberCacheImpl(GemFireVM vm) throws CacheDoesNotExistException {
        this.vm = vm;
        this.info = vm.getCacheInfo();
        if (this.info == null) {
            throw new CacheDoesNotExistException(LocalizedStrings.SystemMemberCacheImpl_THE_VM_0_DOES_NOT_CURRENTLY_HAVE_A_CACHE.toLocalizedString(vm.getId()));
        }
        this.initStats();
    }

    @Override
    public String getName() {
        String result = this.info.getName();
        if (result == null || result.length() == 0) {
            result = "default";
        }
        return result;
    }

    @Override
    public int getId() {
        return this.info.getId();
    }

    @Override
    public boolean isClosed() {
        return this.info.isClosed();
    }

    @Override
    public int getLockTimeout() {
        return this.info.getLockTimeout();
    }

    @Override
    public void setLockTimeout(int seconds) throws AdminException {
        this.info = this.vm.setCacheLockTimeout(this.info, seconds);
    }

    @Override
    public int getLockLease() {
        return this.info.getLockLease();
    }

    @Override
    public void setLockLease(int seconds) throws AdminException {
        this.info = this.vm.setCacheLockLease(this.info, seconds);
    }

    @Override
    public int getSearchTimeout() {
        return this.info.getSearchTimeout();
    }

    @Override
    public void setSearchTimeout(int seconds) throws AdminException {
        this.info = this.vm.setCacheSearchTimeout(this.info, seconds);
    }

    @Override
    public int getUpTime() {
        return this.info.getUpTime();
    }

    @Override
    public Set getRootRegionNames() {
        Set set = this.info.getRootRegionNames();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    @Override
    public void refresh() {
        if (!this.info.isClosed()) {
            CacheInfo cur = this.vm.getCacheInfo();
            if (cur == null || this.info.getId() != cur.getId()) {
                this.info.setClosed();
            } else {
                this.info = cur;
                this.updateStats();
            }
        }
    }

    public GemFireMemberStatus getSnapshot() {
        GemFireMemberStatus stat = this.vm.getSnapshot();
        return stat;
    }

    public RegionSubRegionSnapshot getRegionSnapshot() {
        RegionSubRegionSnapshot snap = this.vm.getRegionSnapshot();
        return snap;
    }

    @Override
    public Statistic[] getStatistics() {
        return this.statistics;
    }

    @Override
    public SystemMemberRegion getRegion(String path) throws AdminException {
        Region r = this.vm.getRegion(this.info, path);
        if (r == null) {
            return null;
        }
        return this.createSystemMemberRegion(r);
    }

    @Override
    public SystemMemberRegion createRegion(String name, RegionAttributes attrs) throws AdminException {
        Region r = this.vm.createVMRootRegion(this.info, name, attrs);
        if (r == null) {
            return null;
        }
        return this.createSystemMemberRegion(r);
    }

    @Override
    public SystemMemberRegion createVMRegion(String name, RegionAttributes attrs) throws AdminException {
        return this.createRegion(name, attrs);
    }

    private void initStats() {
        StatResource resource = this.info.getPerfStats();
        if (resource == null) {
            Assert.assertTrue(this.isClosed());
            return;
        }
        Stat[] stats = resource.getStats();
        if (stats == null || stats.length < 1) {
            this.statistics = new Statistic[0];
            return;
        }
        ArrayList<Statistic> statList = new ArrayList<Statistic>();
        for (int i = 0; i < stats.length; ++i) {
            statList.add(this.createStatistic(stats[i]));
        }
        this.statistics = statList.toArray(new Statistic[statList.size()]);
    }

    private void updateStats() {
        StatResource resource = this.info.getPerfStats();
        if (resource == null) {
            Assert.assertTrue(this.isClosed());
            return;
        }
        Stat[] stats = resource.getStats();
        if (stats == null || stats.length < 1) {
            return;
        }
        for (int i = 0; i < stats.length; ++i) {
            this.updateStatistic(stats[i]);
        }
    }

    private void updateStatistic(Stat stat) {
        for (int i = 0; i < this.statistics.length; ++i) {
            if (!this.statistics[i].getName().equals(stat.getName())) continue;
            ((StatisticImpl)this.statistics[i]).setStat(stat);
            return;
        }
        Assert.assertTrue(false, "Unknown stat: " + stat.getName());
    }

    public CacheInfo getCacheInfo() {
        return this.info;
    }

    public GemFireVM getVM() {
        return this.vm;
    }

    protected Statistic createStatistic(Stat stat) {
        return new StatisticImpl(stat);
    }

    protected SystemMemberRegion createSystemMemberRegion(Region r) throws AdminException {
        SystemMemberRegionImpl sysMemberRegion = new SystemMemberRegionImpl(this, r);
        sysMemberRegion.refresh();
        return sysMemberRegion;
    }

    @Override
    public SystemMemberCacheServer addCacheServer() throws AdminException {
        return (SystemMemberCacheServer)((Object)this.addBridgeServer());
    }

    @Override
    public SystemMemberBridgeServer addBridgeServer() throws AdminException {
        AdminBridgeServer bridge = this.vm.addBridgeServer(this.info);
        SystemMemberBridgeServerImpl admin = this.createSystemMemberBridgeServer(bridge);
        this.bridgeServers.put(bridge.getId(), admin);
        return admin;
    }

    private Collection getCacheServersCollection() throws AdminException {
        ArrayList<SystemMemberBridgeServer> bridges = new ArrayList<SystemMemberBridgeServer>();
        int[] bridgeIds = this.info.getBridgeServerIds();
        for (int i = 0; i < bridgeIds.length; ++i) {
            AdminBridgeServer info;
            int id = bridgeIds[i];
            SystemMemberBridgeServer bridge = (SystemMemberBridgeServer)this.bridgeServers.get(id);
            if (bridge == null && (info = this.vm.getBridgeInfo(this.info, id)) != null) {
                bridge = this.createSystemMemberBridgeServer(info);
                this.bridgeServers.put(info.getId(), bridge);
            }
            if (bridge == null) continue;
            bridges.add(bridge);
        }
        return bridges;
    }

    @Override
    public SystemMemberCacheServer[] getCacheServers() throws AdminException {
        Collection bridges = this.getCacheServersCollection();
        SystemMemberCacheServer[] array = new SystemMemberCacheServer[bridges.size()];
        return bridges.toArray(array);
    }

    @Override
    public SystemMemberBridgeServer[] getBridgeServers() throws AdminException {
        Collection bridges = this.getCacheServersCollection();
        SystemMemberBridgeServer[] array = new SystemMemberBridgeServer[bridges.size()];
        return bridges.toArray(array);
    }

    protected SystemMemberBridgeServerImpl createSystemMemberBridgeServer(AdminBridgeServer bridge) throws AdminException {
        return new SystemMemberBridgeServerImpl(this, bridge);
    }

    @Override
    public boolean isServer() throws AdminException {
        return this.info.isServer();
    }

    public String toString() {
        return this.getName();
    }
}

