/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.ConfigurationParameter;
import com.gemstone.gemfire.admin.StatisticResource;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheEvent;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.admin.internal.ConfigurationParameterImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberImpl;
import com.gemstone.gemfire.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.ConfigurationParameterJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.admin.jmx.internal.RefreshNotificationType;
import com.gemstone.gemfire.admin.jmx.internal.StatisticResourceJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberCacheJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberJmx;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.modeler.ManagedBean;
import org.apache.logging.log4j.Logger;

public class SystemMemberJmxImpl
extends SystemMemberImpl
implements SystemMemberJmx,
NotificationListener,
ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private int refreshInterval = 0;
    private ObjectName objectName;
    private SystemMemberCacheJmxImpl managedSystemMemberCache;
    private Map<StatResource, StatisticResourceJmxImpl> managedStatisticsResourcesMap = new HashMap<StatResource, StatisticResourceJmxImpl>();
    private String mbeanName;
    private ModelMBean modelMBean;

    public SystemMemberJmxImpl(AdminDistributedSystemJmxImpl system, ApplicationVM application) throws AdminException {
        super((AdminDistributedSystem)system, application);
        this.initializeMBean();
    }

    protected SystemMemberJmxImpl(AdminDistributedSystemJmxImpl system, InternalDistributedMember member) throws AdminException {
        super((AdminDistributedSystem)system, member);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = new StringBuffer("GemFire.Member:id=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getId())).append(",type=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getType().getName())).toString();
        this.objectName = MBeanUtil.createMBean(this, this.addDynamicAttributes(MBeanUtil.lookupManagedBean(this)));
        AdminDistributedSystemJmxImpl sysJmx = (AdminDistributedSystemJmxImpl)this.system;
        if (sysJmx.getRefreshInterval() > 0) {
            this.refreshInterval = sysJmx.getRefreshInterval();
        }
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    @Deprecated
    public void setRefreshInterval(int refreshInterval) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(LocalizedStrings.MANAGED_RESOURCE_REFRESH_INTERVAL_CANT_BE_SET_DIRECTLY.toLocalizedString());
    }

    @Override
    public void _setRefreshInterval(int refreshInterval) {
        boolean isRegistered = MBeanUtil.isRefreshNotificationRegistered(this, RefreshNotificationType.SYSTEM_MEMBER_CONFIG);
        if (isRegistered && this.getRefreshInterval() == refreshInterval) {
            return;
        }
        this.refreshInterval = SystemMemberJmx.Helper.setAndReturnRefreshInterval(this, refreshInterval);
    }

    @Override
    public void refreshConfig() throws AdminException {
        if (this.refreshInterval > 0) {
            this._setRefreshInterval(this.refreshInterval);
        }
        super.refreshConfig();
    }

    @Override
    public ObjectName manageCache() throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageCache(this);
    }

    @Override
    public ObjectName[] manageStats() throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageStats(this);
    }

    @Override
    public ObjectName[] manageStat(String statisticsTypeName) throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageStat(this, statisticsTypeName);
    }

    @Override
    public void handleNotification(Notification notification, Object hb) {
        AdminDistributedSystemJmxImpl systemJmx = (AdminDistributedSystemJmxImpl)this.system;
        if (!systemJmx.isRmiClientCountZero()) {
            SystemMemberJmx.Helper.handleNotification(this, notification, hb);
        }
    }

    @Override
    protected ConfigurationParameter createConfigurationParameter(String name, String description, Object value2, Class type, boolean userModifiable) {
        return new ConfigurationParameterJmxImpl(name, description, value2, type, userModifiable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StatisticResource createStatisticResource(StatResource stat) throws AdminException {
        StatisticResourceJmxImpl managedStatisticResource = null;
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            StatisticResourceJmxImpl statisticResourceJmxImpl = this.managedStatisticsResourcesMap.get(stat);
            if (statisticResourceJmxImpl != null) {
                managedStatisticResource = statisticResourceJmxImpl;
            } else {
                managedStatisticResource = new StatisticResourceJmxImpl(stat, this);
                managedStatisticResource.getStatistics();
                this.managedStatisticsResourcesMap.put(stat, managedStatisticResource);
            }
        }
        return managedStatisticResource;
    }

    @Override
    protected SystemMemberCache createSystemMemberCache(GemFireVM vm) throws AdminException {
        if (this.managedSystemMemberCache == null) {
            this.managedSystemMemberCache = new SystemMemberCacheJmxImpl(vm);
        }
        return this.managedSystemMemberCache;
    }

    @Override
    public ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        return SystemMemberJmx.Helper.addDynamicAttributes(this, managed);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupResource() {
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            ConfigurationParameter[] names = this.getConfiguration();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    ConfigurationParameter parm = names[i];
                    ((ConfigurationParameterImpl)parm).removeConfigurationParameterListener(this);
                }
            }
            this.parms.clear();
            Collection<StatisticResourceJmxImpl> statisticResources = this.managedStatisticsResourcesMap.values();
            for (StatisticResourceJmxImpl statisticResource : statisticResources) {
                MBeanUtil.unregisterMBean(statisticResource);
            }
            this.managedStatisticsResourcesMap.clear();
        }
        MBeanUtil.unregisterMBean(this.managedSystemMemberCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ManagedResource> cleanupBridgeClientResources(String clientId) {
        ArrayList<ManagedResource> returnedResources = new ArrayList<ManagedResource>();
        String compatibleId = "id_" + MBeanUtil.makeCompliantMBeanNameProperty(clientId);
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            Set<Map.Entry<StatResource, StatisticResourceJmxImpl>> entrySet = this.managedStatisticsResourcesMap.entrySet();
            Iterator<Map.Entry<StatResource, StatisticResourceJmxImpl>> it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry<StatResource, StatisticResourceJmxImpl> entry = it.next();
                StatisticResourceJmxImpl resource = entry.getValue();
                if (!resource.getMBeanName().contains(compatibleId)) continue;
                it.remove();
                returnedResources.add(resource);
            }
        }
        return returnedResources;
    }

    @Override
    public void handleClientMembership(String clientId, int eventType) {
        String notifType = null;
        List<ManagedResource> cleanedUp = null;
        if (eventType == 1) {
            notifType = "gemfire.distributedsystem.cache.client.left";
            cleanedUp = this.cleanupBridgeClientResources(clientId);
        } else if (eventType == 2) {
            notifType = "gemfire.distributedsystem.cache.client.crashed";
            cleanedUp = this.cleanupBridgeClientResources(clientId);
        } else if (eventType == 0) {
            notifType = "gemfire.distributedsystem.cache.client.joined";
        }
        if (cleanedUp != null) {
            for (ManagedResource resource : cleanedUp) {
                MBeanUtil.unregisterMBean(resource);
            }
        }
        SystemMemberJmx.Helper.sendNotification(this, new Notification(notifType, (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), clientId));
    }

    @Override
    public void handleCacheCreate(SystemMemberCacheEvent event) {
        SystemMemberJmx.Helper.sendNotification(this, new Notification("gemfire.distributedsystem.cache.created", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getCacheEventDetails(event)));
    }

    @Override
    public void handleCacheClose(SystemMemberCacheEvent event) {
        SystemMemberJmx.Helper.sendNotification(this, new Notification("gemfire.distributedsystem.cache.closed", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getCacheEventDetails(event)));
    }

    @Override
    public void handleRegionCreate(SystemMemberRegionEvent event) {
        Notification notification = new Notification("gemfire.distributedsystem.cache.region.created", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getRegionEventDetails(event));
        notification.setUserData(event.getRegionPath());
        SystemMemberJmx.Helper.sendNotification(this, notification);
    }

    @Override
    public void handleRegionLoss(SystemMemberRegionEvent event) {
        ManagedResource cleanedUp;
        SystemMemberCacheJmxImpl cacheResource = this.managedSystemMemberCache;
        if (cacheResource != null && (cleanedUp = cacheResource.cleanupRegionResources(event.getRegionPath())) != null) {
            MBeanUtil.unregisterMBean(cleanedUp);
        }
        Notification notification = new Notification("gemfire.distributedsystem.cache.region.lost", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getRegionEventDetails(event));
        notification.setUserData(event.getRegionPath());
        SystemMemberJmx.Helper.sendNotification(this, notification);
    }
}

