/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class DataPolicy
implements Serializable {
    private static final long serialVersionUID = 2095573273889467233L;
    private static final DataPolicy[] VALUES = new DataPolicy[10];
    public static final DataPolicy EMPTY = new DataPolicy(0, "EMPTY");
    public static final DataPolicy NORMAL = new DataPolicy(1, "NORMAL");
    public static final DataPolicy REPLICATE = new DataPolicy(2, "REPLICATE");
    public static final DataPolicy PERSISTENT_REPLICATE = new DataPolicy(3, "PERSISTENT_REPLICATE");
    public static final DataPolicy PARTITION = new DataPolicy(4, "PARTITION");
    public static final DataPolicy PRELOADED = new DataPolicy(5, "PRELOADED");
    public static final DataPolicy PERSISTENT_PARTITION = new DataPolicy(6, "PERSISTENT_PARTITION");
    public static final DataPolicy DEFAULT = NORMAL;
    private final transient String name;
    public final byte ordinal;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private DataPolicy(int ordinal, String name) {
        if (ordinal >= VALUES.length) {
            throw new IllegalArgumentException(LocalizedStrings.DataPolicy_ONLY_0_DATAPOLICIES_MAY_BE_DEFINED.toLocalizedString(VALUES.length + 1));
        }
        if (VALUES[ordinal] != null) {
            throw new IllegalArgumentException(LocalizedStrings.DataPolicy_ORDINAL_0_IS_ALREADY_DEFINED_BY_1.toLocalizedString(ordinal, VALUES[ordinal]));
        }
        this.name = name;
        this.ordinal = (byte)(ordinal & 0xFF);
        DataPolicy.VALUES[this.ordinal] = this;
    }

    public static DataPolicy fromOrdinal(byte ordinal) {
        return VALUES[ordinal];
    }

    public boolean withStorage() {
        return this != EMPTY;
    }

    public boolean withReplication() {
        return this == REPLICATE || this == PERSISTENT_REPLICATE;
    }

    public boolean withPersistence() {
        return this == PERSISTENT_PARTITION || this == PERSISTENT_REPLICATE;
    }

    public boolean withPartitioning() {
        return this == PARTITION || this == PERSISTENT_PARTITION;
    }

    public boolean withPreloaded() {
        return this == PRELOADED;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isNormal() {
        return this == NORMAL;
    }

    public boolean isPreloaded() {
        return this == PRELOADED;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isReplicate() {
        return this == REPLICATE;
    }

    public boolean isPersistentReplicate() {
        return this == PERSISTENT_REPLICATE;
    }

    public boolean isPartition() {
        return this == PARTITION;
    }

    public String toString() {
        return this.name;
    }
}

