/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.UserSpecifiedRegionAttributes;

public class ClientRegionFactoryImpl<K, V>
implements ClientRegionFactory<K, V> {
    private final AttributesFactory<K, V> attrsFactory;
    private final GemFireCacheImpl cache;

    public ClientRegionFactoryImpl(GemFireCacheImpl cache, ClientRegionShortcut pra) {
        this.cache = cache;
        RegionAttributes ra = cache.getRegionAttributes(pra.toString());
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + (Object)((Object)pra) + " has been removed.");
        }
        this.attrsFactory = new AttributesFactory(ra);
        this.initAttributeFactoryDefaults();
    }

    public ClientRegionFactoryImpl(GemFireCacheImpl cache, String refid) {
        this.cache = cache;
        RegionAttributes ra = cache.getRegionAttributes(refid);
        if (ra == null) {
            throw new IllegalStateException("The named region attributes \"" + refid + "\" has not been defined.");
        }
        this.attrsFactory = new AttributesFactory(ra);
        this.initAttributeFactoryDefaults();
    }

    private void initAttributeFactoryDefaults() {
        this.attrsFactory.setScope(Scope.LOCAL);
        this.attrsFactory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
    }

    private GemFireCacheImpl getCache() {
        return this.cache;
    }

    private Pool getDefaultPool() {
        return this.getCache().getDefaultPool();
    }

    @Override
    public ClientRegionFactory<K, V> addCacheListener(CacheListener<K, V> aListener) {
        this.attrsFactory.addCacheListener(aListener);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> initCacheListeners(CacheListener<K, V>[] newListeners) {
        this.attrsFactory.initCacheListeners(newListeners);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.attrsFactory.setEvictionAttributes(evictionAttributes);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        this.attrsFactory.setEntryIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setCustomEntryIdleTimeout(CustomExpiry<K, V> custom) {
        this.attrsFactory.setCustomEntryIdleTimeout(custom);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setEntryTimeToLive(ExpirationAttributes timeToLive) {
        this.attrsFactory.setEntryTimeToLive(timeToLive);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setCustomEntryTimeToLive(CustomExpiry<K, V> custom) {
        this.attrsFactory.setCustomEntryTimeToLive(custom);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        this.attrsFactory.setRegionIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setRegionTimeToLive(ExpirationAttributes timeToLive) {
        this.attrsFactory.setRegionTimeToLive(timeToLive);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setKeyConstraint(Class<K> keyConstraint) {
        this.attrsFactory.setKeyConstraint(keyConstraint);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setValueConstraint(Class<V> valueConstraint) {
        this.attrsFactory.setValueConstraint(valueConstraint);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setInitialCapacity(int initialCapacity) {
        this.attrsFactory.setInitialCapacity(initialCapacity);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setLoadFactor(float loadFactor) {
        this.attrsFactory.setLoadFactor(loadFactor);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setConcurrencyLevel(int concurrencyLevel) {
        this.attrsFactory.setConcurrencyLevel(concurrencyLevel);
        return this;
    }

    @Override
    public void setConcurrencyChecksEnabled(boolean concurrencyChecksEnabled) {
        this.attrsFactory.setConcurrencyChecksEnabled(concurrencyChecksEnabled);
    }

    @Override
    public ClientRegionFactory<K, V> setDiskStoreName(String name) {
        this.attrsFactory.setDiskStoreName(name);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setDiskSynchronous(boolean isSynchronous) {
        this.attrsFactory.setDiskSynchronous(isSynchronous);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setStatisticsEnabled(boolean statisticsEnabled) {
        this.attrsFactory.setStatisticsEnabled(statisticsEnabled);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setCloningEnabled(boolean cloningEnable) {
        this.attrsFactory.setCloningEnabled(cloningEnable);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setPoolName(String poolName) {
        this.attrsFactory.setPoolName(poolName);
        return this;
    }

    @Override
    public ClientRegionFactory<K, V> setCompressor(Compressor compressor) {
        this.attrsFactory.setCompressor(compressor);
        return this;
    }

    @Override
    public Region<K, V> create(String name) throws RegionExistsException {
        return this.getCache().basicCreateRegion(name, this.createRegionAttributes());
    }

    @Override
    public Region<K, V> createSubregion(Region<?, ?> parent, String name) throws RegionExistsException {
        return ((LocalRegion)parent).createSubregion(name, this.createRegionAttributes());
    }

    private RegionAttributes<K, V> createRegionAttributes() {
        RegionAttributes<K, V> ra = this.attrsFactory.create();
        if (ra.getPoolName() == null || "".equals(ra.getPoolName())) {
            UserSpecifiedRegionAttributes ura = (UserSpecifiedRegionAttributes)ra;
            if (ura.requiresPoolName) {
                Pool dp = this.getDefaultPool();
                if (dp != null) {
                    this.attrsFactory.setPoolName(dp.getName());
                    ra = this.attrsFactory.create();
                } else {
                    throw new IllegalStateException("The poolName must be set on a client.");
                }
            }
        }
        return ra;
    }
}

