/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class CommitOp {
    public static TXCommitMessage execute(ExecutablePool pool, int txId) {
        CommitOpImpl op = new CommitOpImpl(txId);
        pool.execute(op);
        return op.getTXCommitMessageResponse();
    }

    private CommitOp() {
    }

    private static class CommitOpImpl
    extends AbstractOp {
        private int txId;
        private TXCommitMessage tXCommitMessageResponse = null;

        public CommitOpImpl(int txId) {
            super(85, 1);
            this.getMessage().setTransactionId(txId);
            this.txId = txId;
        }

        public TXCommitMessage getTXCommitMessageResponse() {
            return this.tXCommitMessageResponse;
        }

        public String toString() {
            return "TXCommit(txId=" + this.txId + ")";
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            TXCommitMessage rcs = (TXCommitMessage)this.processObjResponse(msg, "commit");
            assert (rcs != null) : "TxCommit response was null";
            this.tXCommitMessageResponse = rcs;
            return rcs;
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 2;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCommit();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCommitSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCommit(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

