/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.cache.client.internal.CloseConnectionOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.ExecuteFunctionOp;
import com.gemstone.gemfire.cache.client.internal.ExecuteRegionFunctionOp;
import com.gemstone.gemfire.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import com.gemstone.gemfire.cache.client.internal.GatewaySenderBatchOp;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SocketUtils;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerQueueStatus;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class ConnectionImpl
implements Connection {
    private static Logger logger = LogService.getLogger();
    private static boolean TEST_DURABLE_CLIENT_CRASH = false;
    private Socket theSocket;
    private ByteBuffer commBuffer;
    private ByteBuffer commBufferForAsyncRead;
    private ServerQueueStatus status;
    private volatile boolean connectFinished;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private Endpoint endpoint;
    private short wanSiteVersion = (short)-1;
    private final DistributedSystem ds;
    private OutputStream out;
    private InputStream in;
    private long connectionID = 26739L;
    private HandShake handShake;

    public ConnectionImpl(DistributedSystem ds, CancelCriterion cancelCriterion) {
        this.ds = ds;
    }

    public ServerQueueStatus connect(EndpointManager endpointManager, ServerLocation location, HandShake handShake, int socketBufferSize, int handShakeTimeout, int readTimeout, byte communicationMode, GatewaySender sender) throws IOException {
        SocketCreator sc = SocketCreator.getDefaultInstance();
        DistributionConfig config = InternalDistributedSystem.getConnectedInstance().getConfig();
        if (communicationMode == 103) {
            sc = SocketCreator.createNonDefaultInstance(config.getGatewaySSLEnabled(), config.getGatewaySSLRequireAuthentication(), config.getGatewaySSLProtocols(), config.getGatewaySSLCiphers(), config.getGatewaySSLProperties());
            if (sender != null && !sender.getGatewayTransportFilters().isEmpty()) {
                sc.initializeTransportFilterClientSocketFactory(sender);
            }
        } else {
            sc = SocketCreator.createNonDefaultInstance(config.getServerSSLEnabled(), config.getServerSSLRequireAuthentication(), config.getServerSSLProtocols(), config.getServerSSLCiphers(), config.getServerSSLProperties());
        }
        if (!sc.isHostReachable(InetAddress.getByName(location.getHostName()))) {
            throw new NoRouteToHostException("Server is not reachable: " + location.getHostName());
        }
        this.theSocket = sc.connectForClient(location.getHostName(), location.getPort(), handShakeTimeout, socketBufferSize);
        this.theSocket.setTcpNoDelay(true);
        this.theSocket.setSendBufferSize(socketBufferSize);
        this.verifySocketBufferSize(socketBufferSize, this.theSocket.getReceiveBufferSize(), "receive");
        this.verifySocketBufferSize(socketBufferSize, this.theSocket.getSendBufferSize(), "send");
        this.theSocket.setSoTimeout(handShakeTimeout);
        this.out = SocketUtils.getOutputStream(this.theSocket);
        this.in = SocketUtils.getInputStream(this.theSocket);
        this.status = handShake.greet(this, location, communicationMode);
        this.commBuffer = ServerConnection.allocateCommBuffer(socketBufferSize);
        if (sender != null) {
            this.commBufferForAsyncRead = ServerConnection.allocateCommBuffer(socketBufferSize);
        }
        this.theSocket.setSoTimeout(readTimeout);
        this.endpoint = endpointManager.referenceEndpoint(location, this.status.getMemberId());
        this.connectFinished = true;
        this.endpoint.getStats().incConnections(1);
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean keepAlive) throws Exception {
        try {
            boolean sendCloseMsg;
            block10: {
                SocketCreator sc = SocketCreator.getDefaultInstance();
                if (!sc.isHostReachable(this.theSocket.getInetAddress())) {
                    return;
                }
                boolean bl = sendCloseMsg = !TEST_DURABLE_CLIENT_CRASH;
                if (sendCloseMsg) {
                    try {
                        ((InternalDistributedSystem)this.ds).getDistributionManager();
                    }
                    catch (CancelException e) {
                        Throwable t = e.getCause();
                        if (!(t instanceof ForcedDisconnectException)) break block10;
                        sendCloseMsg = false;
                    }
                }
            }
            if (sendCloseMsg) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing connection {} with keepAlive: {}", this, keepAlive);
                }
                CloseConnectionOp.execute(this, keepAlive);
            }
        }
        finally {
            this.destroy();
        }
    }

    @Override
    public void emergencyClose() {
        this.commBuffer = null;
        try {
            this.theSocket.close();
        }
        catch (IOException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    @Override
    public void destroy() {
        block6: {
            if (!this.destroyed.compareAndSet(false, true)) {
                return;
            }
            if (this.endpoint != null) {
                if (this.connectFinished) {
                    this.endpoint.getStats().incConnections(-1);
                }
                this.endpoint.removeReference();
            }
            try {
                if (this.theSocket != null) {
                    this.theSocket.close();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public ByteBuffer getCommBuffer() {
        return this.commBuffer;
    }

    @Override
    public ServerLocation getServer() {
        return this.endpoint.getLocation();
    }

    @Override
    public Socket getSocket() {
        return this.theSocket;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public ConnectionStats getStats() {
        return this.endpoint.getStats();
    }

    public String toString() {
        return "Connection[" + this.endpoint + "]@" + this.hashCode();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ServerQueueStatus getQueueStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Op op) throws Exception {
        Object result;
        if (op instanceof GatewaySenderBatchOp.GatewaySenderGFEBatchOpImpl) {
            Object result2 = op.attempt(this);
            this.endpoint.updateLastExecute();
            return result2;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (op instanceof ExecuteFunctionOp.ExecuteFunctionOpImpl || op instanceof ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl || op instanceof ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl) {
                int earliertimeout = this.getSocket().getSoTimeout();
                this.getSocket().setSoTimeout(GemFireCacheImpl.getClientFunctionTimeout());
                result = op.attempt(this);
                this.getSocket().setSoTimeout(earliertimeout);
            } else {
                result = op.attempt(this);
            }
        }
        this.endpoint.updateLastExecute();
        return result;
    }

    public static void loadEmergencyClasses() {
    }

    @Override
    public short getWanSiteVersion() {
        return this.wanSiteVersion;
    }

    @Override
    public void setWanSiteVersion(short wanSiteVersion) {
        this.wanSiteVersion = wanSiteVersion;
    }

    @Override
    public int getDistributedSystemId() {
        return ((InternalDistributedSystem)this.ds).getDistributionManager().getDistributedSystemId();
    }

    @Override
    public void setConnectionID(long id) {
        this.connectionID = id;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    protected HandShake getHandShake() {
        return this.handShake;
    }

    protected void setHandShake(HandShake handShake) {
        this.handShake = handShake;
    }

    public static void setTEST_DURABLE_CLIENT_CRASH(boolean v) {
        TEST_DURABLE_CLIENT_CRASH = v;
    }

    public ByteBuffer getCommBufferForAsyncRead() {
        return this.commBufferForAsyncRead;
    }

    private void verifySocketBufferSize(int requestedBufferSize, int actualBufferSize, String type) {
        if (actualBufferSize < requestedBufferSize) {
            logger.info(LocalizedMessage.create(LocalizedStrings.Connection_SOCKET_0_IS_1_INSTEAD_OF_THE_REQUESTED_2, new Object[]{type + " buffer size", actualBufferSize, requestedBufferSize}));
        }
    }
}

