/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class ContainsKeyOp {
    public static boolean execute(ExecutablePool pool, String region, Object key2, MODE mode) {
        ContainsKeyOpImpl op = new ContainsKeyOpImpl(region, key2, mode);
        Boolean result = (Boolean)pool.execute(op);
        return result;
    }

    private ContainsKeyOp() {
    }

    public static enum MODE {
        KEY,
        VALUE_FOR_KEY,
        VALUE;

    }

    private static class ContainsKeyOpImpl
    extends AbstractOp {
        private String region;
        private Object key;
        private final MODE mode;

        public ContainsKeyOpImpl(String region, Object key2, MODE mode) {
            super(38, 3);
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(key2);
            this.getMessage().addIntPart(mode.ordinal());
            this.region = region;
            this.key = key2;
            this.mode = mode;
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return this.processObjResponse(msg, "containsKey");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 39;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startContainsKey();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endContainsKeySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endContainsKey(start, this.hasTimedOut(), this.hasFailed());
        }

        public String toString() {
            return "ContainsKeyOp(region=" + this.region + ";key=" + this.key + ";mode=" + (Object)((Object)this.mode);
        }
    }
}

